jQuery(document).ready(function($) {
    // App name character counter
    var appNameField = $('#app_name');
    var appNameCount = $('#arewa-app-name-count');
    
    if (appNameField.length && appNameCount.length) {
        function updateAppNameCount() {
            var currentLength = appNameField.val().length;
            var maxLength = 33;
            appNameCount.text('(' + currentLength + '/' + maxLength + ')');
            
            if (currentLength > maxLength) {
                appNameCount.css('color', '#d63638');
                // Truncate to max length
                appNameField.val(appNameField.val().substring(0, maxLength));
                updateAppNameCount();
            } else if (currentLength >= maxLength - 5) {
                appNameCount.css('color', '#d63638');
            } else {
                appNameCount.css('color', '#0073aa');
            }
        }
        
        // Initialize count
        updateAppNameCount();
        
        // Update on input
        appNameField.on('input', function() {
            updateAppNameCount();
        });
        
        // Prevent exceeding max length
        appNameField.on('keypress', function(e) {
            if ($(this).val().length >= 33 && e.which !== 8 && e.which !== 0 && e.which !== 46) {
                e.preventDefault();
                return false;
            }
        });
    }
    
    // Short description character counter
    var shortDescField = $('#arewa_apk_short_description');
    var shortDescCount = $('#arewa-short-desc-count');
    
    if (shortDescField.length && shortDescCount.length) {
        function updateShortDescCount() {
            var currentLength = shortDescField.val().length;
            var maxLength = 100;
            shortDescCount.text('(' + currentLength + '/' + maxLength + ')');
            
            if (currentLength > maxLength) {
                shortDescCount.css('color', '#d63638');
                // Truncate to max length
                shortDescField.val(shortDescField.val().substring(0, maxLength));
                updateShortDescCount();
            } else if (currentLength >= maxLength - 10) {
                shortDescCount.css('color', '#d63638');
            } else {
                shortDescCount.css('color', '#0073aa');
            }
        }
        
        // Initialize count
        updateShortDescCount();
        
        // Update on input
        shortDescField.on('input', function() {
            updateShortDescCount();
        });
        
        // Prevent exceeding max length
        shortDescField.on('keypress', function(e) {
            if ($(this).val().length >= 100 && e.which !== 8 && e.which !== 0 && e.which !== 46) {
                e.preventDefault();
                return false;
            }
        });
    }
    
    // Validate required fields before form submission
    $('#arewa-apk-app-form').on('submit', function(e) {
        var isValid = true;
        var errorMessages = [];
        
        // Check App Name
        if ($('#app_name').val().trim() === '') {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.appNameRequired);
        } else if ($('#app_name').val().length > 33) {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.appNameMaxLength);
        }
        
        // Check Short Description
        if ($('#arewa_apk_short_description').val().trim() === '') {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.shortDescRequired);
        }
        
        // Check App Version
        if ($('#arewa_apk_version').val().trim() === '') {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.appVersionRequired);
        }
        
        // Check App Icon
        if ($('#arewa_apk_icon').val().trim() === '') {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.appIconRequired);
        }
        
        // Check Feature Graphic
        if ($('#arewa_apk_feature_graphic').val().trim() === '') {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.featureGraphicRequired);
        }
        
        // Check Screenshots (at least one)
        if ($('#arewa_apk_screenshots_list .arewa-screenshot-item').length === 0) {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.screenshotsRequired);
        }
        
        // Check APK Download URL
        if ($('#arewa_apk_url').val().trim() === '') {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.apkUrlRequired);
        }
        
        // Check About this app (check if TinyMCE has content)
        var aboutContent = '';
        if (typeof tinyMCE !== 'undefined' && tinyMCE.get('arewa_apk_about')) {
            aboutContent = tinyMCE.get('arewa_apk_about').getContent();
        } else {
            aboutContent = $('#arewa_apk_about').val();
        }
        if (aboutContent.trim() === '' || aboutContent.trim() === '<p></p>') {
            isValid = false;
            errorMessages.push(arewaAPKAdminAddEdit.strings.aboutRequired);
        }
        
        if (!isValid) {
            e.preventDefault();
            alert(errorMessages.join('\n'));
            return false;
        }
    });
    
    // Limit tag selection to maximum 10
    var maxTags = 10;
    var tagCheckboxes = $('.arewa-tag-checkbox');
    
    // Only run if there are tag checkboxes
    if (tagCheckboxes.length > 0) {
        function updateTagCount() {
            var tagCount = $('.arewa-tag-checkbox:checked').length;
            var countElement = $('#arewa-tag-count');
            
            if (countElement.length > 0) {
                countElement.text('(' + tagCount + '/10 ' + arewaAPKAdminAddEdit.strings.selected + ')');
                
                if (tagCount >= maxTags) {
                    // Disable unchecked checkboxes
                    $('.arewa-tag-checkbox:not(:checked)').prop('disabled', true);
                    countElement.css('color', '#d63638');
                } else {
                    // Enable all checkboxes
                    $('.arewa-tag-checkbox').prop('disabled', false);
                    countElement.css('color', '#0073aa');
                }
            }
        }
        
        // Initialize count
        updateTagCount();
        
        // Handle checkbox changes
        tagCheckboxes.on('change', function() {
            var currentCount = $('.arewa-tag-checkbox:checked').length;
            if ($(this).is(':checked')) {
                // If checking and already at max, prevent checking
                if (currentCount >= maxTags) {
                    $(this).prop('checked', false);
                    alert(arewaAPKAdminAddEdit.strings.maxTagsReached);
                    return false;
                }
            }
            updateTagCount();
        });
    }
    
    // Validate category is selected before form submission
    $('#arewa-apk-app-form').on('submit', function(e) {
        var categorySelected = $('.arewa-category-radio:checked').length > 0;
        if (!categorySelected) {
            e.preventDefault();
            alert(arewaAPKAdminAddEdit.strings.categoryRequired);
            return false;
        }
        
        // Validate tags count (already handled by checkbox logic, but double-check)
        var tagCount = $('.arewa-tag-checkbox:checked').length;
        if (tagCount > maxTags) {
            e.preventDefault();
            alert(arewaAPKAdminAddEdit.strings.maxTagsReached);
            return false;
        }
    });
});
