jQuery(document).ready(function($) {
    // Select All checkbox
    $('#arewa-select-all-apps').on('change', function() {
        $('.arewa-app-checkbox').prop('checked', $(this).prop('checked'));
    });
    
    // Export Settings
    $('#arewa-export-settings-form').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this);
        var $result = $('#arewa-export-settings-result');
        
        $result.html('<p style="color: #2271b1;">' + arewaAPKAdminImportExport.strings.exporting + '</p>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'arewapap_export_settings',
                nonce: $('#arewapap_export_settings_nonce').val()
            },
            success: function(response) {
                if (response.success) {
                    var downloadLink = $('<a>', {
                        href: response.data.file_url,
                        download: response.data.filename,
                        text: arewaAPKAdminImportExport.strings.downloadExportFile,
                        class: 'button button-primary',
                        style: 'margin-top: 10px; display: inline-block;'
                    });
                    $result.html('<p style="color: #00a32a;">' + response.data.message + '</p>').append(downloadLink);
                } else {
                    $result.html('<p style="color: #d63638;">' + response.data.message + '</p>');
                }
            },
            error: function() {
                $result.html('<p style="color: #d63638;">' + arewaAPKAdminImportExport.strings.exportError + '</p>');
            }
        });
    });
    
    // Import Settings
    $('#arewa-import-settings-form').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this);
        var $result = $('#arewa-import-settings-result');
        var formData = new FormData(this);
        formData.append('action', 'arewapap_import_settings');
        formData.append('nonce', $('#arewapap_import_settings_nonce').val());
        
        $result.html('<p style="color: #2271b1;">' + arewaAPKAdminImportExport.strings.importing + '</p>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    $result.html('<p style="color: #00a32a;">' + response.data.message + '</p>');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    $result.html('<p style="color: #d63638;">' + response.data.message + '</p>');
                }
            },
            error: function() {
                $result.html('<p style="color: #d63638;">' + arewaAPKAdminImportExport.strings.importError + '</p>');
            }
        });
    });
    
    // Export Content
    $('#arewa-export-content-form').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this);
        var $result = $('#arewa-export-content-result');
        var selectedApps = $('.arewa-app-checkbox:checked').map(function() {
            return $(this).val();
        }).get();
        
        if (selectedApps.length === 0) {
            $result.html('<p style="color: #d63638;">' + arewaAPKAdminImportExport.strings.selectAppsToExport + '</p>');
            return;
        }
        
        $result.html('<p style="color: #2271b1;">' + arewaAPKAdminImportExport.strings.exporting + '</p>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'arewapap_export_content',
                nonce: $('#arewapap_export_content_nonce').val(),
                app_ids: selectedApps
            },
            success: function(response) {
                if (response.success) {
                    var downloadLink = $('<a>', {
                        href: response.data.file_url,
                        download: response.data.filename,
                        text: arewaAPKAdminImportExport.strings.downloadExportFile,
                        class: 'button button-primary',
                        style: 'margin-top: 10px; display: inline-block;'
                    });
                    $result.html('<p style="color: #00a32a;">' + response.data.message + '</p>').append(downloadLink);
                } else {
                    $result.html('<p style="color: #d63638;">' + response.data.message + '</p>');
                }
            },
            error: function() {
                $result.html('<p style="color: #d63638;">' + arewaAPKAdminImportExport.strings.exportError + '</p>');
            }
        });
    });
    
    // Import Content
    $('#arewa-import-content-form').on('submit', function(e) {
        e.preventDefault();
        var $form = $(this);
        var $result = $('#arewa-import-content-result');
        var $btn = $('#arewa-import-content-btn');
        var $btnText = $btn.find('.arewa-import-btn-text');
        var $spinner = $btn.find('.arewa-import-spinner');
        var formData = new FormData(this);
        formData.append('action', 'arewapap_import_content');
        formData.append('nonce', $('#arewapap_import_content_nonce').val());
        
        $btn.prop('disabled', true);
        $btnText.hide();
        $spinner.show();
        $result.html('<p style="color: #2271b1;">' + arewaAPKAdminImportExport.strings.importingLong + '</p>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            timeout: 300000, // 5 minutes
            success: function(response) {
                $btn.prop('disabled', false);
                $btnText.show();
                $spinner.hide();
                
                if (response.success) {
                    var message = '<p style="color: #00a32a;">' + response.data.message + '</p>';
                    if (response.data.imported_count > 0) {
                        message += '<p><strong>' + arewaAPKAdminImportExport.strings.imported + '</strong> ' + response.data.imported_count + '</p>';
                    }
                    if (response.data.skipped_count > 0) {
                        message += '<p><strong>' + arewaAPKAdminImportExport.strings.skipped + '</strong> ' + response.data.skipped_count + '</p>';
                    }
                    if (response.data.errors && response.data.errors.length > 0) {
                        message += '<p style="color: #d63638;"><strong>' + arewaAPKAdminImportExport.strings.errors + '</strong></p><ul>';
                        response.data.errors.forEach(function(error) {
                            message += '<li>' + error + '</li>';
                        });
                        message += '</ul>';
                    }
                    $result.html(message);
                    setTimeout(function() {
                        location.reload();
                    }, 3000);
                } else {
                    $result.html('<p style="color: #d63638;">' + response.data.message + '</p>');
                }
            },
            error: function(xhr, status, error) {
                $btn.prop('disabled', false);
                $btnText.show();
                $spinner.hide();
                
                var errorMsg = arewaAPKAdminImportExport.strings.importError;
                if (status === 'timeout') {
                    errorMsg = arewaAPKAdminImportExport.strings.importTimeout;
                } else if (xhr.responseJSON && xhr.responseJSON.data && xhr.responseJSON.data.message) {
                    errorMsg = xhr.responseJSON.data.message;
                }
                $result.html('<p style="color: #d63638;">' + errorMsg + '</p>');
            }
        });
    });
});
