<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get app data if editing
$app_id = isset($_GET['app_id']) ? absint($_GET['app_id']) : 0;
$is_edit = $app_id > 0;

if ($is_edit) {
    $app = get_post($app_id);
    if (!$app || $app->post_type !== 'arewa_apk_app') {
        wp_die(esc_html__('App not found.', 'arewa-apk-apps-manager'));
    }
    
    $app_name = $app->post_title;
    $app_version = get_post_meta($app_id, '_arewa_apk_version', true) ?: '1.0.0';
    $app_icon = get_post_meta($app_id, '_arewa_apk_icon', true);
    $feature_graphic = get_post_meta($app_id, '_arewa_apk_feature_graphic', true);
    $app_screenshots = get_post_meta($app_id, '_arewa_apk_screenshots', true);
    if (!is_array($app_screenshots)) {
        $app_screenshots = array();
    }
    $apk_url = get_post_meta($app_id, '_arewa_apk_url', true);
    $short_description = get_post_meta($app_id, '_arewa_apk_short_description', true);
    $about_app = get_post_meta($app_id, '_arewa_apk_about', true);
    $comments_per_page = absint(get_post_meta($app_id, '_arewa_apk_comments_per_page', true) ?: 10);
    $disable_seo = get_post_meta($app_id, '_arewa_apk_disable_seo', true) ?: 'no';
    $post_status = $app->post_status;
    $post_date = $app->post_date;
    $post_date_gmt = $app->post_date_gmt;
    
    // Get categories (only one allowed)
    $selected_categories = wp_get_object_terms($app_id, 'arewa_apk_category', array('fields' => 'ids'));
    $selected_category = !empty($selected_categories) ? $selected_categories[0] : 0;
    
    // Get tags (up to 10 allowed)
    $selected_tags = wp_get_object_terms($app_id, 'arewa_apk_tag', array('fields' => 'ids'));
} else {
    $app_name = '';
    $app_version = '1.0.0';
    $app_icon = '';
    $app_screenshots = array();
    $apk_url = '';
    $short_description = '';
    $about_app = '';
    $comments_per_page = 10;
    $disable_seo = 'no';
    $post_status = 'publish';
    $post_date = current_time('mysql');
    $post_date_gmt = current_time('mysql', 1);
    $selected_category = 0;
    $selected_tags = array();
}

// Get all categories
$categories = get_terms(array(
    'taxonomy' => 'arewa_apk_category',
    'hide_empty' => false,
));

// Get all tags
$tags = get_terms(array(
    'taxonomy' => 'arewa_apk_tag',
    'hide_empty' => false,
));

$page_title = $is_edit ? __('Edit App', 'arewa-apk-apps-manager') : __('Add New App', 'arewa-apk-apps-manager');
?>

<div class="wrap arewa-apk-admin">
    <h1><?php echo esc_html($page_title); ?></h1>
    
    <?php if (isset($_GET['saved']) && $_GET['saved'] == '1'): ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e('App saved successfully!', 'arewa-apk-apps-manager'); ?></p>
        </div>
    <?php endif; ?>
    
    <form method="post" action="" id="arewa-apk-app-form">
        <?php wp_nonce_field('arewa_apk_save_app', 'arewa_apk_app_nonce'); ?>
        <?php if ($is_edit): ?>
            <input type="hidden" name="app_id" value="<?php echo esc_attr($app_id); ?>" />
        <?php endif; ?>
        
        <div class="arewa-apk-settings-container">
            <div class="arewa-apk-settings-section">
                <h2><?php esc_html_e('App Information', 'arewa-apk-apps-manager'); ?></h2>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="app_name"><?php esc_html_e('App Name', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <input type="text" id="app_name" name="app_name" value="<?php echo esc_attr($app_name); ?>" class="regular-text" required maxlength="33" />
                            <p class="description">
                                <?php esc_html_e('Enter the name of your application (maximum 33 characters).', 'arewa-apk-apps-manager'); ?>
                                <span id="arewa-app-name-count" style="font-weight: bold; color: #0073aa;">(<?php echo esc_html(strlen($app_name)); ?>/33)</span>
                            </p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_short_description"><?php esc_html_e('Short Description', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <textarea id="arewa_apk_short_description" name="arewa_apk_short_description" class="large-text" rows="3" maxlength="100" required><?php echo esc_textarea($short_description); ?></textarea>
                            <p class="description">
                                <?php esc_html_e('Enter a short description of your app (maximum 100 characters). This will be displayed in the app list.', 'arewa-apk-apps-manager'); ?>
                                <span id="arewa-short-desc-count" style="font-weight: bold; color: #0073aa;">(<?php echo esc_html(strlen($short_description)); ?>/100)</span>
                            </p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_version"><?php esc_html_e('App Version', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <input type="text" id="arewa_apk_version" name="arewa_apk_version" value="<?php echo esc_attr($app_version); ?>" class="regular-text" required />
                            <p class="description"><?php esc_html_e('Enter the current version of your app (e.g., 1.0.0).', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_icon"><?php esc_html_e('App Icon', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <div class="arewa-upload-wrapper">
                                <input type="url" id="arewa_apk_icon" name="arewa_apk_icon" value="<?php echo esc_url($app_icon); ?>" class="regular-text" required />
                                <button type="button" class="button arewa-upload-button" data-target="arewa_apk_icon"><?php esc_html_e('Upload Image', 'arewa-apk-apps-manager'); ?></button>
                                <button type="button" class="button arewa-remove-button" data-target="arewa_apk_icon" style="display: <?php echo $app_icon ? 'inline-block' : 'none'; ?>"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                            </div>
                            <div class="arewa-image-preview" id="arewa_apk_icon_preview" style="margin-top: 10px;">
                                <?php if ($app_icon): ?>
                                    <img src="<?php echo esc_url($app_icon); ?>" alt="App Icon" style="max-width: 150px; height: auto; border: 1px solid #ddd; padding: 5px; border-radius: 4px;" />
                                <?php endif; ?>
                            </div>
                            <p class="description"><?php esc_html_e('Upload the app icon image. Recommended size: 512x512 pixels.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_feature_graphic"><?php esc_html_e('Feature Graphic', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <div class="arewa-upload-wrapper">
                                <input type="url" id="arewa_apk_feature_graphic" name="arewa_apk_feature_graphic" value="<?php echo esc_url($feature_graphic); ?>" class="regular-text" required />
                                <button type="button" class="button arewa-upload-button" data-target="arewa_apk_feature_graphic"><?php esc_html_e('Upload Image', 'arewa-apk-apps-manager'); ?></button>
                                <button type="button" class="button arewa-remove-button" data-target="arewa_apk_feature_graphic" style="display: <?php echo $feature_graphic ? 'inline-block' : 'none'; ?>"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                            </div>
                            <div class="arewa-image-preview" id="arewa_apk_feature_graphic_preview" style="margin-top: 10px;">
                                <?php if ($feature_graphic): ?>
                                    <img src="<?php echo esc_url($feature_graphic); ?>" alt="Feature Graphic" style="max-width: 300px; height: auto; border: 1px solid #ddd; padding: 5px; border-radius: 4px;" />
                                <?php endif; ?>
                            </div>
                            <p class="description"><?php esc_html_e('Upload the feature graphic image. Recommended size: 1920x1080 pixels.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_screenshots"><?php esc_html_e('App Screenshots', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <div class="arewa-upload-wrapper">
                                <button type="button" class="button arewa-upload-multiple-button" data-target="arewa_apk_screenshots"><?php esc_html_e('Select Screenshots', 'arewa-apk-apps-manager'); ?></button>
                            </div>
                            <div class="arewa-screenshots-list" id="arewa_apk_screenshots_list" style="margin-top: 15px;">
                                <?php if (!empty($app_screenshots)): ?>
                                    <?php foreach ($app_screenshots as $index => $screenshot): ?>
                                        <div class="arewa-screenshot-item" data-index="<?php echo esc_attr($index); ?>" style="display: inline-block; margin: 5px; position: relative;">
                                            <input type="hidden" name="arewa_apk_screenshots[]" value="<?php echo esc_url($screenshot); ?>" />
                                            <img src="<?php echo esc_url($screenshot); ?>" alt="<?php
                                            // translators: %d: Screenshot index number
                                            echo esc_attr(sprintf(__('Screenshot %d', 'arewa-apk-apps-manager'), $index + 1));
                                            ?>" style="max-width: 150px; height: auto; border: 1px solid #ddd; padding: 5px; border-radius: 4px; display: block;" />
                                            <button type="button" class="button arewa-remove-screenshot" style="margin-top: 5px; width: 100%;"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <p class="description"><?php esc_html_e('Upload at least one app screenshot image. Recommended size: 1080x1920 pixels or similar. You can select multiple images at once.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_url"><?php esc_html_e('APK Download URL', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <input type="url" id="arewa_apk_url" name="arewa_apk_url" value="<?php echo esc_url($apk_url); ?>" class="regular-text" required />
                            <p class="description"><?php esc_html_e('Enter the direct download URL for your APK file.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_about"><?php esc_html_e('About this app', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <?php 
                            wp_editor($about_app, 'arewa_apk_about', array(
                                'textarea_name' => 'arewa_apk_about',
                                'textarea_rows' => 10,
                                'media_buttons' => true,
                                'teeny' => false,
                                'tinymce' => true,
                                'quicktags' => true
                            )); 
                            ?>
                            <p class="description"><?php esc_html_e('Enter a description about your app. This text will be displayed after the screenshots and before the Comments & Reviews section. HTML is allowed.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="arewa_apk_comments_per_page"><?php esc_html_e('Comments Per Page', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <input type="number" id="arewa_apk_comments_per_page" name="arewa_apk_comments_per_page" value="<?php echo esc_attr($comments_per_page); ?>" class="small-text" min="1" max="100" />
                            <p class="description"><?php esc_html_e('Number of comments to display per page.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row"><?php esc_html_e('Disable Plugin SEO', 'arewa-apk-apps-manager'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="arewa_apk_disable_seo" value="yes" <?php checked($disable_seo, 'yes'); ?> />
                                <?php esc_html_e('Disable all SEO features from this plugin', 'arewa-apk-apps-manager'); ?>
                            </label>
                            <p class="description">
                                <?php esc_html_e('Check this if you experience SEO conflicts or want to handle all SEO through your SEO plugin only.', 'arewa-apk-apps-manager'); ?>
                            </p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label><?php esc_html_e('App Category', 'arewa-apk-apps-manager'); ?> <span class="required">*</span></label>
                        </th>
                        <td>
                            <?php if (!empty($categories) && !is_wp_error($categories)): ?>
                            <div id="arewa-categories-container">
                                <?php
                                foreach ($categories as $category) {
                                    $checked = ($selected_category == $category->term_id) ? 'checked' : '';
                                    echo '<label style="display: block; margin: 5px 0;">';
                                    echo '<input type="radio" class="arewa-category-radio" name="arewa_apk_category" value="' . esc_attr($category->term_id) . '" ' . esc_attr($checked) . ' required /> ';
                                    echo esc_html($category->name);
                                    echo '</label>';
                                }
                                ?>
                            </div>
                            <p class="description">
                                <?php esc_html_e('Select one category for your app.', 'arewa-apk-apps-manager'); ?>
                                <br>
                                <a href="<?php echo esc_url(admin_url('edit-tags.php?taxonomy=arewa_apk_category&post_type=arewa_apk_app')); ?>"><?php esc_html_e('Manage categories', 'arewa-apk-apps-manager'); ?></a>
                            </p>
                            <?php else: ?>
                            <div class="notice notice-info inline" style="padding: 10px; margin: 0;">
                                <p>
                                    <?php esc_html_e('No categories available. Default categories will be created automatically.', 'arewa-apk-apps-manager'); ?>
                                </p>
                            </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label><?php esc_html_e('App Tags', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <?php if (!empty($tags) && !is_wp_error($tags)): ?>
                            <div id="arewa-tags-container" style="max-height: 300px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; border-radius: 4px;">
                                <?php
                                $selected_tag_ids = array_map('intval', $selected_tags);
                                foreach ($tags as $tag) {
                                    $checked = in_array($tag->term_id, $selected_tag_ids) ? 'checked' : '';
                                    echo '<label style="display: block; margin: 5px 0;">';
                                    echo '<input type="checkbox" class="arewa-tag-checkbox" name="arewa_apk_tags[]" value="' . esc_attr($tag->term_id) . '" ' . esc_attr($checked) . ' data-tag-id="' . esc_attr($tag->term_id) . '" /> ';
                                    echo esc_html($tag->name);
                                    echo '</label>';
                                }
                                ?>
                            </div>
                            <p class="description">
                                <?php esc_html_e('Select up to 10 tags for your app.', 'arewa-apk-apps-manager'); ?>
                                <span id="arewa-tag-count" style="font-weight: bold; color: #0073aa;">
                                    (<?php echo esc_html(count($selected_tags)); ?>/10 <?php esc_html_e('selected', 'arewa-apk-apps-manager'); ?>)
                                </span>
                                <br>
                                <a href="<?php echo esc_url(admin_url('edit-tags.php?taxonomy=arewa_apk_tag&post_type=arewa_apk_app')); ?>"><?php esc_html_e('Manage tags', 'arewa-apk-apps-manager'); ?></a>
                            </p>
                            <?php else: ?>
                            <div class="notice notice-info inline" style="padding: 10px; margin: 0;">
                                <p>
                                    <?php esc_html_e('No tags available. Default tags will be created automatically.', 'arewa-apk-apps-manager'); ?>
                                </p>
                            </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="post_status"><?php esc_html_e('Status', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <select id="post_status" name="post_status">
                                <option value="draft" <?php selected($post_status, 'draft'); ?>><?php esc_html_e('Draft', 'arewa-apk-apps-manager'); ?></option>
                                <option value="publish" <?php selected($post_status, 'publish'); ?>><?php esc_html_e('Published', 'arewa-apk-apps-manager'); ?></option>
                            </select>
                            <p class="description"><?php esc_html_e('Set the publication status of this app.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="post_date"><?php esc_html_e('Published Date', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <?php
                            $post_date_local = $is_edit ? get_date_from_gmt($post_date_gmt) : $post_date;
                            $date = $post_date_local ? mysql2date('Y-m-d', $post_date_local, false) : current_time('Y-m-d');
                            $time = $post_date_local ? mysql2date('H:i:s', $post_date_local, false) : current_time('H:i:s');
                            ?>
                            <input type="date" id="post_date" name="post_date" value="<?php echo esc_attr($date); ?>" class="regular-text" />
                            <input type="time" id="post_time" name="post_time" value="<?php echo esc_attr(substr($time, 0, 5)); ?>" class="regular-text" style="margin-left: 10px;" />
                            <p class="description"><?php esc_html_e('Set the publication date and time for this app.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <p class="submit">
            <input type="submit" name="arewa_apk_save_app" class="button button-primary" value="<?php echo esc_attr($is_edit ? __('Update App', 'arewa-apk-apps-manager') : __('Save App', 'arewa-apk-apps-manager')); ?>" />
            <input type="submit" name="save_and_continue" class="button" value="<?php esc_attr_e('Save and Continue Editing', 'arewa-apk-apps-manager'); ?>" />
            <a href="<?php echo esc_url(admin_url('edit.php?post_type=arewa_apk_app')); ?>" class="button"><?php esc_html_e('Cancel', 'arewa-apk-apps-manager'); ?></a>
        </p>
    </form>
</div>

<?php
// Detect SEO plugin automatically
$seo_plugin_active = false;
$seo_plugin_name = '';
if (defined('RANK_MATH_VERSION') || class_exists('RankMath') || 
    (function_exists('is_plugin_active') && is_plugin_active('seo-by-rank-math/rank-math.php'))) {
    $seo_plugin_active = true;
    $seo_plugin_name = 'Rank Math SEO';
} elseif (defined('WPSEO_VERSION') || class_exists('WPSEO_Options') || 
    (function_exists('is_plugin_active') && is_plugin_active('wordpress-seo/wp-seo.php'))) {
    $seo_plugin_active = true;
    $seo_plugin_name = 'Yoast SEO';
} elseif (defined('AIOSEO_VERSION') || class_exists('AIOSEO') || 
    (function_exists('is_plugin_active') && is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php'))) {
    $seo_plugin_active = true;
    $seo_plugin_name = 'All in One SEO';
} elseif (defined('SEOPRESS_VERSION') || function_exists('seopress_get_service') || 
    (function_exists('is_plugin_active') && is_plugin_active('wp-seopress/seopress.php'))) {
    $seo_plugin_active = true;
    $seo_plugin_name = 'SEOPress';
} elseif (defined('THE_SEO_FRAMEWORK_VERSION') || class_exists('The_SEO_Framework') || 
    (function_exists('is_plugin_active') && is_plugin_active('autodescription/autodescription.php'))) {
    $seo_plugin_active = true;
    $seo_plugin_name = 'The SEO Framework';
} elseif (defined('SQ_VERSION') || class_exists('SQ_Classes_FrontController') || 
    (function_exists('is_plugin_active') && is_plugin_active('squirrly-seo/squirrly.php'))) {
    $seo_plugin_active = true;
    $seo_plugin_name = 'Squirrly SEO';
} elseif (defined('SEOPRESSOR_VERSION') || 
    (function_exists('is_plugin_active') && is_plugin_active('seo-pressor/seo-pressor.php'))) {
    $seo_plugin_active = true;
    $seo_plugin_name = 'SEOPressor';
}
?>

<?php if ($seo_plugin_active): ?>
<div class="notice notice-info" style="margin: 20px 0; padding: 15px;">
    <p>
        <strong><?php esc_html_e('SEO Plugin Detected:', 'arewa-apk-apps-manager'); ?></strong>
        <?php echo esc_html($seo_plugin_name); ?> <?php esc_html_e('is active and will work automatically with this plugin.', 'arewa-apk-apps-manager'); ?>
    </p>
    <p>
        <?php esc_html_e('This plugin will automatically add SoftwareApplication schema for your app, while', 'arewa-apk-apps-manager'); ?> 
        <?php echo esc_html($seo_plugin_name); ?> 
        <?php esc_html_e('handles Article schema and other meta tags. Both work together without conflicts.', 'arewa-apk-apps-manager'); ?>
    </p>
</div>
<?php endif; ?>

<?php
// Admin add-edit-app script is now enqueued via wp_enqueue_script in enqueue_admin_assets()
?>

