<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="arewa-apk-meta-box">
    <table class="form-table">
        <tr>
            <th scope="row">
                <label for="arewa_apk_version"><?php esc_html_e('App Version', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <input type="text" id="arewa_apk_version" name="arewa_apk_version" value="<?php echo esc_attr($app_version); ?>" class="regular-text" />
                <p class="description"><?php esc_html_e('Enter the current version of your app (e.g., 1.0.0).', 'arewa-apk-apps-manager'); ?></p>
            </td>
        </tr>
        
        <tr>
            <th scope="row">
                <label for="arewa_apk_icon"><?php esc_html_e('App Icon', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <div class="arewa-upload-wrapper">
                    <input type="url" id="arewa_apk_icon" name="arewa_apk_icon" value="<?php echo esc_url($app_icon); ?>" class="regular-text" />
                    <button type="button" class="button arewa-upload-button" data-target="arewa_apk_icon"><?php esc_html_e('Upload Image', 'arewa-apk-apps-manager'); ?></button>
                    <button type="button" class="button arewa-remove-button" data-target="arewa_apk_icon" style="display: <?php echo $app_icon ? 'inline-block' : 'none'; ?>"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                </div>
                <div class="arewa-image-preview" id="arewa_apk_icon_preview" style="margin-top: 10px;">
                    <?php if ($app_icon): ?>
                        <img src="<?php echo esc_url($app_icon); ?>" alt="App Icon" style="max-width: 150px; height: auto; border: 1px solid #ddd; padding: 5px; border-radius: 4px;" />
                    <?php endif; ?>
                </div>
                <p class="description"><?php esc_html_e('Upload the app icon image. Recommended size: 512x512 pixels.', 'arewa-apk-apps-manager'); ?></p>
            </td>
        </tr>
        
        <tr>
            <th scope="row">
                <label for="arewa_apk_feature_graphic"><?php esc_html_e('Feature Graphic', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <?php 
                global $post;
                $feature_graphic = get_post_meta($post->ID, '_arewa_apk_feature_graphic', true);
                ?>
                <div class="arewa-upload-wrapper">
                    <input type="url" id="arewa_apk_feature_graphic" name="arewa_apk_feature_graphic" value="<?php echo esc_url($feature_graphic); ?>" class="regular-text" />
                    <button type="button" class="button arewa-upload-button" data-target="arewa_apk_feature_graphic"><?php esc_html_e('Upload Image', 'arewa-apk-apps-manager'); ?></button>
                    <button type="button" class="button arewa-remove-button" data-target="arewa_apk_feature_graphic" style="display: <?php echo $feature_graphic ? 'inline-block' : 'none'; ?>"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                </div>
                <div class="arewa-image-preview" id="arewa_apk_feature_graphic_preview" style="margin-top: 10px;">
                    <?php if ($feature_graphic): ?>
                        <img src="<?php echo esc_url($feature_graphic); ?>" alt="Feature Graphic" style="max-width: 300px; height: auto; border: 1px solid #ddd; padding: 5px; border-radius: 4px;" />
                    <?php endif; ?>
                </div>
                <p class="description"><?php esc_html_e('Upload the feature graphic image. Recommended size: 1920x1080 pixels.', 'arewa-apk-apps-manager'); ?></p>
            </td>
        </tr>
        
        <tr>
            <th scope="row">
                <label for="arewa_apk_screenshots"><?php esc_html_e('App Screenshots', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <div class="arewa-upload-wrapper">
                    <button type="button" class="button arewa-upload-multiple-button" data-target="arewa_apk_screenshots"><?php esc_html_e('Select Screenshots', 'arewa-apk-apps-manager'); ?></button>
                </div>
                <div class="arewa-screenshots-list" id="arewa_apk_screenshots_list" style="margin-top: 15px;">
                    <?php if (!empty($app_screenshots)): ?>
                        <?php foreach ($app_screenshots as $index => $screenshot): ?>
                            <div class="arewa-screenshot-item" data-index="<?php echo esc_attr($index); ?>" style="display: inline-block; margin: 5px; position: relative;">
                                <input type="hidden" name="arewa_apk_screenshots[]" value="<?php echo esc_url($screenshot); ?>" />
                                <img src="<?php echo esc_url($screenshot); ?>" alt="<?php
                                // translators: %d: Screenshot index number
                                echo esc_attr(sprintf(__('Screenshot %d', 'arewa-apk-apps-manager'), $index + 1));
                                ?>" style="max-width: 150px; height: auto; border: 1px solid #ddd; padding: 5px; border-radius: 4px; display: block;" />
                                <button type="button" class="button arewa-remove-screenshot" style="margin-top: 5px; width: 100%;"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <p class="description"><?php esc_html_e('Upload multiple app screenshot images. Recommended size: 1080x1920 pixels or similar. You can select multiple images at once.', 'arewa-apk-apps-manager'); ?></p>
            </td>
        </tr>
        
        <tr>
            <th scope="row">
                <label for="arewa_apk_url"><?php esc_html_e('APK Download URL', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <input type="url" id="arewa_apk_url" name="arewa_apk_url" value="<?php echo esc_url($apk_url); ?>" class="regular-text" />
                <p class="description"><?php esc_html_e('Enter the direct download URL for your APK file.', 'arewa-apk-apps-manager'); ?></p>
            </td>
        </tr>
        
        <tr>
            <th scope="row">
                <label for="arewa_apk_short_description"><?php esc_html_e('Short Description', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <?php 
                // Get short_description if not already set
                if (!isset($short_description)) {
                    global $post;
                    $short_description = get_post_meta($post->ID, '_arewa_apk_short_description', true);
                }
                ?>
                <textarea id="arewa_apk_short_description" name="arewa_apk_short_description" class="large-text" rows="3" maxlength="100"><?php echo esc_textarea($short_description); ?></textarea>
                <p class="description">
                    <?php esc_html_e('Enter a short description of your app (maximum 100 characters). This will be displayed in the app list.', 'arewa-apk-apps-manager'); ?>
                    <span id="arewa-short-desc-count-meta" style="font-weight: bold; color: #0073aa;">(<?php echo esc_html(strlen($short_description ?: '')); ?>/100)</span>
                </p>
            </td>
        </tr>
        
        <tr>
            <th scope="row">
                <label for="arewa_apk_about"><?php esc_html_e('About this app', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <?php 
                wp_editor($about_app, 'arewa_apk_about', array(
                    'textarea_name' => 'arewa_apk_about',
                    'textarea_rows' => 10,
                    'media_buttons' => true,
                    'teeny' => false,
                    'tinymce' => true,
                    'quicktags' => true
                )); 
                ?>
                <p class="description"><?php esc_html_e('Enter a description about your app. This text will be displayed after the screenshots and before the Comments & Reviews section. HTML is allowed.', 'arewa-apk-apps-manager'); ?></p>
            </td>
        </tr>
        
        <tr>
            <th scope="row">
                <label for="arewa_apk_comments_per_page"><?php esc_html_e('Comments Per Page', 'arewa-apk-apps-manager'); ?></label>
            </th>
            <td>
                <input type="number" id="arewa_apk_comments_per_page" name="arewa_apk_comments_per_page" value="<?php echo esc_attr($comments_per_page); ?>" class="small-text" min="1" max="100" />
                <p class="description"><?php esc_html_e('Number of comments to display per page.', 'arewa-apk-apps-manager'); ?></p>
            </td>
        </tr>
        
        <tr>
            <th scope="row"><?php esc_html_e('Disable Plugin SEO', 'arewa-apk-apps-manager'); ?></th>
            <td>
                <label>
                    <input type="checkbox" name="arewa_apk_disable_seo" value="yes" <?php checked($disable_seo, 'yes'); ?> />
                    <?php esc_html_e('Disable all SEO features from this plugin', 'arewa-apk-apps-manager'); ?>
                </label>
                <p class="description">
                    <?php esc_html_e('Check this if you experience SEO conflicts or want to handle all SEO through your SEO plugin only.', 'arewa-apk-apps-manager'); ?>
                </p>
            </td>
        </tr>
    </table>
</div>

