<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$table_name = $wpdb->prefix . 'arewa_apk_comments';
$comments_per_page = 15;
$current_page = isset($_GET['paged']) ? absint($_GET['paged']) : 1;
if ($current_page < 1) {
    $current_page = 1;
}
$offset = ($current_page - 1) * $comments_per_page;

// Handle actions
if (isset($_GET['action']) && isset($_GET['comment_id'])) {
    $comment_id = absint($_GET['comment_id']);
    
    if ($_GET['action'] === 'delete' && check_admin_referer('delete_comment_' . $comment_id)) {
        $wpdb->delete($table_name, array('id' => $comment_id), array('%d'));
        echo '<div class="notice notice-success"><p>' . esc_html__('Comment deleted successfully!', 'arewa-apk-apps-manager') . '</p></div>';
    } elseif ($_GET['action'] === 'approve' && check_admin_referer('approve_comment_' . $comment_id)) {
        $wpdb->update($table_name, array('approved' => 1), array('id' => $comment_id), array('%d'), array('%d'));
        echo '<div class="notice notice-success"><p>' . esc_html__('Comment approved successfully!', 'arewa-apk-apps-manager') . '</p></div>';
    } elseif ($_GET['action'] === 'unapprove' && check_admin_referer('unapprove_comment_' . $comment_id)) {
        $wpdb->update($table_name, array('approved' => 0), array('id' => $comment_id), array('%d'), array('%d'));
        echo '<div class="notice notice-success"><p>' . esc_html__('Comment unapproved successfully!', 'arewa-apk-apps-manager') . '</p></div>';
    }
}

// Escape table name for security
$table_name_escaped = esc_sql($table_name);
$total_comments = $wpdb->get_var("SELECT COUNT(*) FROM `{$table_name_escaped}`");
$comments = $wpdb->get_results($wpdb->prepare(
    "SELECT * FROM `{$table_name_escaped}` ORDER BY comment_date DESC LIMIT %d OFFSET %d",
    absint($comments_per_page),
    absint($offset)
));
$total_pages = ceil($total_comments / $comments_per_page);
?>

<div class="wrap arewa-apk-comments">
    <h1><?php esc_html_e('APK App Comments', 'arewa-apk-apps-manager'); ?></h1>
    
    <?php if (empty($comments)): ?>
        <p><?php esc_html_e('No comments yet.', 'arewa-apk-apps-manager'); ?></p>
    <?php else: ?>
        <div class="tablenav top">
            <div class="alignleft actions bulkactions">
                <!-- Bulk actions can be added here if needed -->
            </div>
            <div class="tablenav-pages">
                <?php
                if ($total_pages > 1) {
                    // Build pagination URL properly
                    $pagination_base = admin_url('admin.php?page=arewa-apk-comments');
                    $pagination_base = remove_query_arg('paged', $pagination_base);
                    $pagination_base = add_query_arg('paged', '%#%', $pagination_base);
                    
                    $page_links = paginate_links(array(
                        'base' => $pagination_base,
                        'format' => '',
                        'prev_text' => esc_html__('&laquo;', 'arewa-apk-apps-manager'),
                        'next_text' => esc_html__('&raquo;', 'arewa-apk-apps-manager'),
                        'total' => $total_pages,
                        'current' => $current_page,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1
                    ));
                    
                    $start_num = ($current_page - 1) * $comments_per_page + 1;
                    $end_num = min($current_page * $comments_per_page, $total_comments);
                    
                    echo '<span class="displaying-num">' . esc_html(sprintf(
                        /* translators: %s: Number of comments */
                        _n('%s comment', '%s comments', $total_comments, 'arewa-apk-apps-manager'),
                        number_format_i18n($total_comments)
                    )) . '</span>';
                    
                    if ($page_links) {
                        echo '<span class="pagination-links">';
                        echo wp_kses_post($page_links);
                        echo '</span>';
                    }
                } else {
                    echo '<span class="displaying-num">' . esc_html(sprintf(
                        /* translators: %s: Number of comments */
                        _n('%s comment', '%s comments', $total_comments, 'arewa-apk-apps-manager'),
                        number_format_i18n($total_comments)
                    )) . '</span>';
                }
                ?>
            </div>
        </div>
        
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th style="width: 150px;"><?php esc_html_e('Author', 'arewa-apk-apps-manager'); ?></th>
                    <th style="width: 180px;"><?php esc_html_e('Email', 'arewa-apk-apps-manager'); ?></th>
                    <th><?php esc_html_e('Comment', 'arewa-apk-apps-manager'); ?></th>
                    <th style="width: 100px;"><?php esc_html_e('Rating', 'arewa-apk-apps-manager'); ?></th>
                    <th style="width: 100px;"><?php esc_html_e('Votes', 'arewa-apk-apps-manager'); ?></th>
                    <th style="width: 150px;"><?php esc_html_e('Date', 'arewa-apk-apps-manager'); ?></th>
                    <th style="width: 100px;"><?php esc_html_e('Status', 'arewa-apk-apps-manager'); ?></th>
                    <th style="width: 150px;"><?php esc_html_e('Actions', 'arewa-apk-apps-manager'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($comments as $comment): ?>
                    <tr data-comment-id="<?php echo esc_attr($comment->id); ?>">
                        <td><strong><?php echo esc_html($comment->author_name); ?></strong></td>
                        <td><?php echo esc_html($comment->author_email); ?></td>
                        <td>
                            <div class="arewa-comment-text"><?php echo esc_html(wp_trim_words($comment->comment_text, 20)); ?></div>
                            <?php if (!empty($comment->author_avatar)): ?>
                                <div class="arewa-comment-avatar-small">
                                    <img src="<?php echo esc_url($comment->author_avatar); ?>" alt="<?php echo esc_attr($comment->author_name); ?>" style="width: 30px; height: 30px; border-radius: 50%; margin-top: 5px;" />
                                </div>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($comment->rating > 0): ?>
                                <div class="arewa-rating-display">
                                    <?php for ($i = 1; $i <= 5; $i++): ?>
                                        <span class="dashicons dashicons-star-filled" style="color: <?php echo esc_attr($i <= $comment->rating ? '#00ff45' : '#ccc'); ?>; font-size: 14px;"></span>
                                    <?php endfor; ?>
                                    <small>(<?php echo esc_html($comment->rating); ?>/5)</small>
                                </div>
                            <?php else: ?>
                                <small><?php esc_html_e('No rating', 'arewa-apk-apps-manager'); ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small>
                                <?php esc_html_e('Helpful:', 'arewa-apk-apps-manager'); ?> <?php echo absint($comment->vote_helpful); ?><br>
                                <?php esc_html_e('Not Helpful:', 'arewa-apk-apps-manager'); ?> <?php echo absint($comment->vote_not_helpful); ?>
                            </small>
                        </td>
                        <td><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($comment->comment_date))); ?></td>
                        <td>
                            <?php if ($comment->approved): ?>
                                <span style="color: green;"><?php esc_html_e('Approved', 'arewa-apk-apps-manager'); ?></span>
                            <?php else: ?>
                                <span style="color: orange;"><?php esc_html_e('Pending', 'arewa-apk-apps-manager'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="#" class="arewa-reply-btn" data-comment-id="<?php echo esc_attr($comment->id); ?>"><?php esc_html_e('Reply', 'arewa-apk-apps-manager'); ?></a> |
                            <?php if ($comment->approved): ?>
                                <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=arewa-apk-comments&action=unapprove&comment_id=' . $comment->id), 'unapprove_comment_' . $comment->id)); ?>"><?php esc_html_e('Unapprove', 'arewa-apk-apps-manager'); ?></a> |
                            <?php else: ?>
                                <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=arewa-apk-comments&action=approve&comment_id=' . $comment->id), 'approve_comment_' . $comment->id)); ?>"><?php esc_html_e('Approve', 'arewa-apk-apps-manager'); ?></a> |
                            <?php endif; ?>
                            <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=arewa-apk-comments&action=delete&comment_id=' . $comment->id), 'delete_comment_' . $comment->id)); ?>" onclick="return confirm('<?php echo esc_js(__('Are you sure you want to delete this comment?', 'arewa-apk-apps-manager')); ?>');" style="color: #a00;"><?php esc_html_e('Delete', 'arewa-apk-apps-manager'); ?></a>
                        </td>
                    </tr>
                    <tr class="arewa-reply-row" id="arewa-reply-row-<?php echo esc_attr($comment->id); ?>" style="display: none;">
                        <td colspan="8">
                            <div class="arewa-admin-reply-container">
                                <h3><?php esc_html_e('Admin Reply', 'arewa-apk-apps-manager'); ?></h3>
                                
                                <?php if (!empty($comment->admin_reply_text) || !empty($comment->admin_reply_image) || !empty($comment->admin_reply_url)): ?>
                                    <div class="arewa-existing-reply">
                                        <h4><?php esc_html_e('Current Reply:', 'arewa-apk-apps-manager'); ?></h4>
                                        <div class="arewa-reply-content">
                                            <?php if (!empty($comment->admin_reply_text)): ?>
                                                <p><?php echo nl2br(esc_html($comment->admin_reply_text)); ?></p>
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($comment->admin_reply_image)): ?>
                                                <div class="arewa-reply-image">
                                                    <img src="<?php echo esc_url($comment->admin_reply_image); ?>" alt="<?php esc_attr_e('Reply image', 'arewa-apk-apps-manager'); ?>" style="max-width: 300px; height: auto; border-radius: 8px; margin: 10px 0;" />
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($comment->admin_reply_url)): ?>
                                                <div class="arewa-reply-url">
                                                    <a href="<?php echo esc_url($comment->admin_reply_url); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html($comment->admin_reply_url); ?></a>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($comment->admin_reply_date)): ?>
                                                <small style="color: #999;"><?php esc_html_e('Replied on:', 'arewa-apk-apps-manager'); ?> <?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($comment->admin_reply_date))); ?></small>
                                            <?php endif; ?>
                                        </div>
                                        <button type="button" class="button arewa-delete-reply-btn" data-comment-id="<?php echo esc_attr($comment->id); ?>" style="margin-top: 10px;"><?php esc_html_e('Delete Reply', 'arewa-apk-apps-manager'); ?></button>
                                    </div>
                                <?php endif; ?>
                                
                                <form class="arewa-admin-reply-form" data-comment-id="<?php echo esc_attr($comment->id); ?>" enctype="multipart/form-data">
                                    <div class="arewa-reply-field">
                                        <label for="reply_text_<?php echo esc_attr($comment->id); ?>"><?php esc_html_e('Reply Text', 'arewa-apk-apps-manager'); ?></label>
                                        <textarea id="reply_text_<?php echo esc_attr($comment->id); ?>" name="reply_text" rows="4" style="width: 100%;"><?php echo esc_textarea($comment->admin_reply_text ?? ''); ?></textarea>
                                    </div>
                                    
                                    <div class="arewa-reply-field">
                                        <label for="reply_url_<?php echo esc_attr($comment->id); ?>"><?php esc_html_e('Reply URL (Optional)', 'arewa-apk-apps-manager'); ?></label>
                                        <input type="url" id="reply_url_<?php echo esc_attr($comment->id); ?>" name="reply_url" value="<?php echo esc_url($comment->admin_reply_url ?? ''); ?>" style="width: 100%;" placeholder="https://example.com" />
                                    </div>
                                    
                                    <div class="arewa-reply-field">
                                        <label for="reply_image_<?php echo esc_attr($comment->id); ?>"><?php esc_html_e('Reply Image (Optional)', 'arewa-apk-apps-manager'); ?></label>
                                        <div class="arewa-reply-image-upload">
                                            <input type="file" id="reply_image_<?php echo esc_attr($comment->id); ?>" name="reply_image" accept="image/*" style="display: none;" />
                                            <button type="button" class="button arewa-select-image-btn" data-comment-id="<?php echo esc_attr($comment->id); ?>">
                                                <span class="dashicons dashicons-camera"></span> <?php esc_html_e('Select Image', 'arewa-apk-apps-manager'); ?>
                                            </button>
                                            <?php if (!empty($comment->admin_reply_image)): ?>
                                                <div class="arewa-reply-image-preview" style="margin-top: 10px;">
                                                    <img src="<?php echo esc_url($comment->admin_reply_image); ?>" alt="<?php esc_attr_e('Current image', 'arewa-apk-apps-manager'); ?>" style="max-width: 200px; height: auto; border-radius: 8px;" />
                                                    <button type="button" class="button-link arewa-remove-image-btn" data-comment-id="<?php echo esc_attr($comment->id); ?>" style="margin-left: 10px;"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                                                </div>
                                            <?php else: ?>
                                                <div class="arewa-reply-image-preview" style="display: none; margin-top: 10px;">
                                                    <img src="" alt="<?php esc_attr_e('Preview', 'arewa-apk-apps-manager'); ?>" style="max-width: 200px; height: auto; border-radius: 8px;" />
                                                    <button type="button" class="button-link arewa-remove-image-btn" data-comment-id="<?php echo esc_attr($comment->id); ?>" style="margin-left: 10px;"><?php esc_html_e('Remove', 'arewa-apk-apps-manager'); ?></button>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    
                                    <div class="arewa-reply-actions">
                                        <button type="submit" class="button button-primary arewa-save-reply-btn" data-comment-id="<?php echo esc_attr($comment->id); ?>"><?php esc_html_e('Save Reply', 'arewa-apk-apps-manager'); ?></button>
                                        <button type="button" class="button arewa-cancel-reply-btn" data-comment-id="<?php echo esc_attr($comment->id); ?>"><?php esc_html_e('Cancel', 'arewa-apk-apps-manager'); ?></button>
                                        <span class="arewa-reply-message" style="margin-left: 10px;"></span>
                                    </div>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div class="tablenav bottom">
            <div class="alignleft actions bulkactions">
                <!-- Bulk actions can be added here if needed -->
            </div>
            <div class="tablenav-pages">
                <?php
                if ($total_pages > 1) {
                    // Build pagination URL properly
                    $pagination_base = admin_url('admin.php?page=arewa-apk-comments');
                    $pagination_base = remove_query_arg('paged', $pagination_base);
                    $pagination_base = add_query_arg('paged', '%#%', $pagination_base);
                    
                    $page_links = paginate_links(array(
                        'base' => $pagination_base,
                        'format' => '',
                        'prev_text' => esc_html__('&laquo;', 'arewa-apk-apps-manager'),
                        'next_text' => esc_html__('&raquo;', 'arewa-apk-apps-manager'),
                        'total' => $total_pages,
                        'current' => $current_page,
                        'type' => 'plain',
                        'end_size' => 2,
                        'mid_size' => 1
                    ));
                    
                    $start_num = ($current_page - 1) * $comments_per_page + 1;
                    $end_num = min($current_page * $comments_per_page, $total_comments);
                    
                    echo '<span class="displaying-num">' . wp_kses_post(sprintf(
                        /* translators: %1$s: Start number, %2$s: End number, %3$s: Total count HTML */
                        __('%1$s&#8211;%2$s of %3$s', 'arewa-apk-apps-manager'),
                        esc_html(number_format_i18n($start_num)),
                        esc_html(number_format_i18n($end_num)),
                        '<span class="total-type-count">' . esc_html(number_format_i18n($total_comments)) . '</span>'
                    )) . '</span>';
                    
                    if ($page_links) {
                        echo '<span class="pagination-links">';
                        echo wp_kses_post($page_links);
                        echo '</span>';
                    }
                } else {
                    echo '<span class="displaying-num">' . esc_html(sprintf(
                        /* translators: %s: Number of comments */
                        _n('%s comment', '%s comments', $total_comments, 'arewa-apk-apps-manager'),
                        number_format_i18n($total_comments)
                    )) . '</span>';
                }
                ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php
// Admin comments styles are now enqueued via wp_enqueue_style in enqueue_admin_assets()
?>
