<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

$settings = Arewa_APK_App::get_settings();
$plugin_settings = Arewa_APK_App::get_plugin_settings();
$download_count = Arewa_APK_App::get_download_count();

// Get all apps
$all_apps = get_posts(array(
    'post_type' => 'arewa_apk_app',
    'posts_per_page' => -1,
    'post_status' => 'any',
    'orderby' => 'title',
    'order' => 'ASC',
));

$published_apps = 0;
$draft_apps = 0;
foreach ($all_apps as $app) {
    if ($app->post_status === 'publish') {
        $published_apps++;
    } else {
        $draft_apps++;
    }
}
?>

<div class="wrap">
    <h1><?php esc_html_e('Import / Export Settings', 'arewa-apk-apps-manager'); ?></h1>
    
    <div class="arewa-apk-admin-container">
        <!-- Export Settings Section -->
        <div class="arewa-apk-section">
            <h2><?php esc_html_e('Export Plugin Settings', 'arewa-apk-apps-manager'); ?></h2>
            <p><?php esc_html_e('Export your plugin settings to a JSON file. This includes all configuration options but NOT app content.', 'arewa-apk-apps-manager'); ?></p>
            
            <form id="arewa-export-settings-form" method="post">
                <?php wp_nonce_field('arewapap_export_settings', 'arewapap_export_settings_nonce'); ?>
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('Export Settings', 'arewa-apk-apps-manager'); ?>
                </button>
            </form>
            
            <div id="arewa-export-settings-result" style="margin-top: 15px;"></div>
        </div>
        
        <!-- Import Settings Section -->
        <div class="arewa-apk-section">
            <h2><?php esc_html_e('Import Plugin Settings', 'arewa-apk-apps-manager'); ?></h2>
            <p><?php esc_html_e('Import plugin settings from a JSON file. This will overwrite your current settings.', 'arewa-apk-apps-manager'); ?></p>
            
            <form id="arewa-import-settings-form" method="post" enctype="multipart/form-data">
                <?php wp_nonce_field('arewapap_import_settings', 'arewapap_import_settings_nonce'); ?>
                <input type="file" name="import_file" accept=".json" required>
                <button type="submit" class="button button-primary" style="margin-top: 10px;">
                    <?php esc_html_e('Import Settings', 'arewa-apk-apps-manager'); ?>
                </button>
            </form>
            
            <div id="arewa-import-settings-result" style="margin-top: 15px;"></div>
        </div>
        
        <!-- Export Apps Content Section -->
        <div class="arewa-apk-section">
            <h2><?php esc_html_e('Export Apps Content', 'arewa-apk-apps-manager'); ?></h2>
            <p><?php esc_html_e('Export selected apps with all their content (metadata, comments, media files) to a ZIP file. This does NOT include plugin settings.', 'arewa-apk-apps-manager'); ?></p>
            
            <?php if (empty($all_apps)): ?>
                <p style="color: #d63638;"><?php esc_html_e('No apps found to export.', 'arewa-apk-apps-manager'); ?></p>
            <?php else: ?>
                <div style="margin: 15px 0;">
                    <label>
                        <input type="checkbox" id="arewa-select-all-apps" style="margin-right: 5px;">
                        <strong><?php esc_html_e('Select All', 'arewa-apk-apps-manager'); ?></strong>
                    </label>
                </div>
                
                <div style="max-height: 400px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; margin: 15px 0;">
                    <?php foreach ($all_apps as $app): 
                        $app_icon = get_post_meta($app->ID, '_arewa_apk_icon', true);
                        $app_version = get_post_meta($app->ID, '_arewa_apk_version', true);
                        $app_downloads = absint(get_post_meta($app->ID, '_arewa_apk_download_count', true) ?: 0);
                        $app_status = $app->post_status;
                    ?>
                        <div style="padding: 10px; border-bottom: 1px solid #eee; display: flex; align-items: center;">
                            <input type="checkbox" 
                                   name="app_ids[]" 
                                   value="<?php echo esc_attr($app->ID); ?>" 
                                   class="arewa-app-checkbox"
                                   style="margin-right: 10px;">
                            
                            <?php if ($app_icon): ?>
                                <img src="<?php echo esc_url($app_icon); ?>" 
                                     alt="<?php echo esc_attr($app->post_title); ?>" 
                                     style="width: 40px; height: 40px; object-fit: cover; margin-right: 10px; border-radius: 4px;">
                            <?php endif; ?>
                            
                            <div style="flex: 1;">
                                <strong><?php echo esc_html($app->post_title); ?></strong>
                                <?php if ($app_version): ?>
                                    <span style="color: #666; margin-left: 10px;">v<?php echo esc_html($app_version); ?></span>
                                <?php endif; ?>
                                <div style="font-size: 12px; color: #666; margin-top: 3px;">
                                    <?php esc_html_e('Status:', 'arewa-apk-apps-manager'); ?> 
                                    <span style="color: <?php echo esc_attr($app_status === 'publish' ? '#00a32a' : '#d63638'); ?>;">
                                        <?php echo esc_html(ucfirst($app_status)); ?>
                                    </span>
                                    <?php if ($app_downloads > 0): ?>
                                        | <?php esc_html_e('Downloads:', 'arewa-apk-apps-manager'); ?> <?php echo esc_html(number_format_i18n($app_downloads)); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <form id="arewa-export-content-form" method="post">
                    <?php wp_nonce_field('arewapap_export_content', 'arewapap_export_content_nonce'); ?>
                    <button type="submit" class="button button-primary">
                        <?php esc_html_e('Export Selected Apps', 'arewa-apk-apps-manager'); ?>
                    </button>
                </form>
                
                <div id="arewa-export-content-result" style="margin-top: 15px;"></div>
            <?php endif; ?>
        </div>
        
        <!-- Import Apps Content Section -->
        <div class="arewa-apk-section">
            <h2><?php esc_html_e('Import Apps from ZIP', 'arewa-apk-apps-manager'); ?></h2>
            <p><?php esc_html_e('Import apps from a ZIP file exported from another WordPress site. Apps with the same slug will be skipped to prevent duplicates.', 'arewa-apk-apps-manager'); ?></p>
            
            <form id="arewa-import-content-form" method="post" enctype="multipart/form-data">
                <?php wp_nonce_field('arewapap_import_content', 'arewapap_import_content_nonce'); ?>
                <input type="file" name="import_file" accept=".zip" required>
                <button type="submit" class="button button-primary" style="margin-top: 10px;" id="arewa-import-content-btn">
                    <span class="arewa-import-btn-text"><?php esc_html_e('Import Apps', 'arewa-apk-apps-manager'); ?></span>
                    <span class="arewa-import-spinner" style="display: none; margin-left: 10px;"><?php esc_html_e('Importing...', 'arewa-apk-apps-manager'); ?></span>
                </button>
            </form>
            
            <div id="arewa-import-content-result" style="margin-top: 15px;"></div>
        </div>
    </div>
</div>

<?php
// Admin import-export styles and scripts are now enqueued via wp_enqueue_style/wp_enqueue_script in enqueue_admin_assets()
?>

