<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

$plugin_settings = Arewa_APK_App::get_plugin_settings();
$enable_comments = $plugin_settings['enable_comments'] ?? 'yes';
$allow_avatar_upload = $plugin_settings['allow_avatar_upload'] ?? 'yes';
$comments_per_page = $plugin_settings['comments_per_page'] ?? 10;
$require_approval = $plugin_settings['require_approval'] ?? 'no';

// Archive list display settings
$show_download_button = $plugin_settings['show_download_button'] ?? 'no';
$show_short_description = $plugin_settings['show_short_description'] ?? 'no';
$show_categories = $plugin_settings['show_categories'] ?? 'no';
$show_version = $plugin_settings['show_version'] ?? 'no';
$show_last_updated = $plugin_settings['show_last_updated'] ?? 'no';
$show_download_count = $plugin_settings['show_download_count'] ?? 'no';
$show_rating = $plugin_settings['show_rating'] ?? 'yes';
$show_excerpt = $plugin_settings['show_excerpt'] ?? 'no';
$posts_per_page = $plugin_settings['posts_per_page'] ?? get_option('posts_per_page', 10);

// Handle form submission
if (isset($_POST['arewa_apk_save_plugin_settings']) && check_admin_referer('arewa_apk_plugin_settings', 'arewa_apk_plugin_settings_nonce')) {
    $plugin_settings['enable_comments'] = isset($_POST['enable_comments']) && $_POST['enable_comments'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['allow_avatar_upload'] = isset($_POST['allow_avatar_upload']) && $_POST['allow_avatar_upload'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['comments_per_page'] = absint($_POST['comments_per_page'] ?? 10);
    $plugin_settings['require_approval'] = isset($_POST['require_approval']) && $_POST['require_approval'] === 'yes' ? 'yes' : 'no';
    
    // Archive list display settings
    $plugin_settings['show_download_button'] = isset($_POST['show_download_button']) && $_POST['show_download_button'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['show_short_description'] = isset($_POST['show_short_description']) && $_POST['show_short_description'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['show_categories'] = isset($_POST['show_categories']) && $_POST['show_categories'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['show_version'] = isset($_POST['show_version']) && $_POST['show_version'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['show_last_updated'] = isset($_POST['show_last_updated']) && $_POST['show_last_updated'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['show_download_count'] = isset($_POST['show_download_count']) && $_POST['show_download_count'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['show_rating'] = isset($_POST['show_rating']) && $_POST['show_rating'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['show_excerpt'] = isset($_POST['show_excerpt']) && $_POST['show_excerpt'] === 'yes' ? 'yes' : 'no';
    $plugin_settings['posts_per_page'] = absint($_POST['posts_per_page'] ?? get_option('posts_per_page', 10));
    
    update_option('arewa_apk_plugin_settings', $plugin_settings);
    echo '<div class="notice notice-success"><p>' . esc_html__('Plugin settings saved successfully!', 'arewa-apk-apps-manager') . '</p></div>';
    
    // Update local variables
    $enable_comments = $plugin_settings['enable_comments'];
    $allow_avatar_upload = $plugin_settings['allow_avatar_upload'];
    $comments_per_page = $plugin_settings['comments_per_page'];
    $require_approval = $plugin_settings['require_approval'];
    $show_download_button = $plugin_settings['show_download_button'];
    $show_short_description = $plugin_settings['show_short_description'];
    $show_categories = $plugin_settings['show_categories'];
    $show_version = $plugin_settings['show_version'];
    $show_last_updated = $plugin_settings['show_last_updated'];
    $show_download_count = $plugin_settings['show_download_count'];
    $show_rating = $plugin_settings['show_rating'];
    $show_excerpt = $plugin_settings['show_excerpt'];
    $posts_per_page = $plugin_settings['posts_per_page'];
}
?>

<div class="wrap arewa-apk-admin">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <form method="post" action="" id="arewa-apk-plugin-settings-form">
        <?php wp_nonce_field('arewa_apk_plugin_settings', 'arewa_apk_plugin_settings_nonce'); ?>
        
        <div class="arewa-apk-settings-container">
            <div class="arewa-apk-settings-section">
                <h2><?php esc_html_e('Archive List Display Settings', 'arewa-apk-apps-manager'); ?></h2>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="posts_per_page"><?php esc_html_e('Number of Apps Per Page', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <input type="number" id="posts_per_page" name="posts_per_page" value="<?php echo esc_attr($posts_per_page); ?>" class="small-text" min="1" max="100" />
                            <p class="description">
                                <?php esc_html_e('Number of apps to display per page on the archive list. Default is the WordPress setting for posts per page.', 'arewa-apk-apps-manager'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e('Show Elements in App List', 'arewa-apk-apps-manager'); ?></th>
                        <td>
                            <fieldset>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_download_button" value="yes" <?php checked($show_download_button, 'yes'); ?> />
                                    <?php esc_html_e('Show Download Button', 'arewa-apk-apps-manager'); ?>
                                </label>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_short_description" value="yes" <?php checked($show_short_description, 'yes'); ?> />
                                    <?php esc_html_e('Show Short Description', 'arewa-apk-apps-manager'); ?>
                                </label>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_categories" value="yes" <?php checked($show_categories, 'yes'); ?> />
                                    <?php esc_html_e('Show Categories', 'arewa-apk-apps-manager'); ?>
                                </label>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_version" value="yes" <?php checked($show_version, 'yes'); ?> />
                                    <?php esc_html_e('Show Version', 'arewa-apk-apps-manager'); ?>
                                </label>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_last_updated" value="yes" <?php checked($show_last_updated, 'yes'); ?> />
                                    <?php esc_html_e('Show Last Updated Date', 'arewa-apk-apps-manager'); ?>
                                </label>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_download_count" value="yes" <?php checked($show_download_count, 'yes'); ?> />
                                    <?php esc_html_e('Show Download Count', 'arewa-apk-apps-manager'); ?>
                                </label>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_rating" value="yes" <?php checked($show_rating, 'yes'); ?> />
                                    <?php esc_html_e('Show Rating', 'arewa-apk-apps-manager'); ?>
                                </label>
                                <label style="display: block; margin: 8px 0;">
                                    <input type="checkbox" name="show_excerpt" value="yes" <?php checked($show_excerpt, 'yes'); ?> />
                                    <?php esc_html_e('Show Excerpt', 'arewa-apk-apps-manager'); ?>
                                </label>
                            </fieldset>
                            <p class="description">
                                <?php esc_html_e('Control which elements are displayed in the app archive list page. Uncheck to hide specific elements.', 'arewa-apk-apps-manager'); ?>
                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <div class="arewa-apk-settings-section">
                <h2><?php esc_html_e('Comments & Reviews Settings', 'arewa-apk-apps-manager'); ?></h2>
                
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="enable_comments"><?php esc_html_e('Enable Comments', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" id="enable_comments" name="enable_comments" value="yes" <?php checked($enable_comments, 'yes'); ?> />
                                <?php esc_html_e('Allow users to submit comments and reviews', 'arewa-apk-apps-manager'); ?>
                            </label>
                            <p class="description">
                                <?php esc_html_e('When enabled, users can submit comments and reviews on all apps. When disabled, the comments section will be hidden on the frontend.', 'arewa-apk-apps-manager'); ?>
                            </p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="allow_avatar_upload"><?php esc_html_e('Allow Profile Photo Upload', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" id="allow_avatar_upload" name="allow_avatar_upload" value="yes" <?php checked($allow_avatar_upload, 'yes'); ?> />
                                <?php esc_html_e('Allow users to upload profile photos in comments', 'arewa-apk-apps-manager'); ?>
                            </label>
                            <p class="description">
                                <?php esc_html_e('When enabled, users can upload a profile photo when submitting a comment. If disabled, only the first letter of their name will be displayed.', 'arewa-apk-apps-manager'); ?>
                            </p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="comments_per_page"><?php esc_html_e('Comments Per Page', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <input type="number" id="comments_per_page" name="comments_per_page" value="<?php echo esc_attr($comments_per_page); ?>" class="small-text" min="1" max="100" />
                            <p class="description"><?php esc_html_e('Number of comments to display per page on the frontend.', 'arewa-apk-apps-manager'); ?></p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th scope="row">
                            <label for="require_approval"><?php esc_html_e('Require Comment Approval', 'arewa-apk-apps-manager'); ?></label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" id="require_approval" name="require_approval" value="yes" <?php checked($require_approval, 'yes'); ?> />
                                <?php esc_html_e('Comments require admin approval before being displayed', 'arewa-apk-apps-manager'); ?>
                            </label>
                            <p class="description">
                                <?php esc_html_e('When enabled, new comments will be marked as pending and require admin approval before appearing on the frontend. You can approve comments from the Comments page.', 'arewa-apk-apps-manager'); ?>
                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <div class="arewa-apk-settings-section">
                <h2><?php esc_html_e('CSS Customization', 'arewa-apk-apps-manager'); ?></h2>
                
                <div class="notice notice-info" style="padding: 15px; margin: 15px 0;">
                    <p>
                        <strong><?php esc_html_e('Recommended:', 'arewa-apk-apps-manager'); ?></strong>
                        <?php esc_html_e('Use WordPress Additional CSS for live preview while editing. Go to', 'arewa-apk-apps-manager'); ?>
                        <a href="<?php echo esc_url(admin_url('customize.php?autofocus[section]=custom_css')); ?>" target="_blank">
                            <strong><?php esc_html_e('Appearance > Customize > Additional CSS', 'arewa-apk-apps-manager'); ?></strong>
                        </a>
                    </p>
                    <p>
                        <?php esc_html_e('The plugin CSS already includes CSS variables with default values. To customize, simply override the CSS variables in WordPress Additional CSS. See CUSTOM-CSS.txt file for examples.', 'arewa-apk-apps-manager'); ?>
                    </p>
                    <p>
                        <strong><?php esc_html_e('Example:', 'arewa-apk-apps-manager'); ?></strong>
                        <code style="display: block; padding: 10px; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; margin: 10px 0; font-size: 12px;">
:root {<br>
&nbsp;&nbsp;--arewa-header-gradient-start: #4facfe;<br>
&nbsp;&nbsp;--arewa-header-gradient-end: #00f2fe;<br>
}
                        </code>
                    </p>
                </div>
            </div>
            
            <div class="arewa-apk-settings-section">
                <h2><?php esc_html_e('SEO (Search Engine Optimization)', 'arewa-apk-apps-manager'); ?></h2>
                
                <?php
                // Check for active SEO plugins
                $seo_plugin_active = false;
                $seo_plugin_name = '';
                if (defined('RANK_MATH_VERSION') || class_exists('RankMath')) {
                    $seo_plugin_active = true;
                    $seo_plugin_name = 'Rank Math SEO';
                } elseif (defined('WPSEO_VERSION') || class_exists('WPSEO_Options')) {
                    $seo_plugin_active = true;
                    $seo_plugin_name = 'Yoast SEO';
                } elseif (defined('AIOSEO_VERSION') || class_exists('AIOSEO')) {
                    $seo_plugin_active = true;
                    $seo_plugin_name = 'All in One SEO';
                } elseif (defined('SEOPRESS_VERSION') || function_exists('seopress_get_service')) {
                    $seo_plugin_active = true;
                    $seo_plugin_name = 'SEOPress';
                } elseif (defined('THE_SEO_FRAMEWORK_VERSION') || class_exists('The_SEO_Framework')) {
                    $seo_plugin_active = true;
                    $seo_plugin_name = 'The SEO Framework';
                }
                ?>
                
                <?php if ($seo_plugin_active): ?>
                    <div class="notice notice-info" style="padding: 15px; margin: 15px 0;">
                        <p>
                            <strong><?php esc_html_e('SEO Plugin Detected:', 'arewa-apk-apps-manager'); ?></strong>
                            <?php echo esc_html($seo_plugin_name); ?> <?php esc_html_e('is active.', 'arewa-apk-apps-manager'); ?>
                        </p>
                        <p>
                            <?php esc_html_e('This plugin will automatically work with your SEO plugin. It will only add SoftwareApplication schema and let your SEO plugin handle Article schema and other meta tags to avoid conflicts.', 'arewa-apk-apps-manager'); ?>
                        </p>
                    </div>
                <?php else: ?>
                    <div class="notice notice-success" style="padding: 15px; margin: 15px 0;">
                        <p>
                            <strong><?php esc_html_e('Good News:', 'arewa-apk-apps-manager'); ?></strong>
                            <?php esc_html_e('The plugin automatically adds SEO meta tags and structured data when apps are displayed.', 'arewa-apk-apps-manager'); ?>
                        </p>
                    </div>
                <?php endif; ?>
                
                <table class="form-table">
                    <tr>
                        <th scope="row"><?php esc_html_e('SEO Features', 'arewa-apk-apps-manager'); ?></th>
                        <td>
                            <ul style="list-style: disc; margin-left: 20px;">
                                <li><strong><?php esc_html_e('Schema.org Structured Data:', 'arewa-apk-apps-manager'); ?></strong> <?php esc_html_e('Automatically adds JSON-LD schema for SoftwareApplication (mobile app) with ratings, downloads, screenshots, etc.', 'arewa-apk-apps-manager'); ?></li>
                                <li><strong><?php esc_html_e('Open Graph Meta Tags:', 'arewa-apk-apps-manager'); ?></strong> <?php esc_html_e('Automatically adds Open Graph tags for better sharing on Facebook, LinkedIn, etc.', 'arewa-apk-apps-manager'); ?></li>
                                <li><strong><?php esc_html_e('Twitter Cards:', 'arewa-apk-apps-manager'); ?></strong> <?php esc_html_e('Automatically adds Twitter Card meta tags for better sharing on Twitter.', 'arewa-apk-apps-manager'); ?></li>
                                <li><strong><?php esc_html_e('Average Rating:', 'arewa-apk-apps-manager'); ?></strong> <?php esc_html_e('Automatically calculates and includes average rating from all comments in structured data.', 'arewa-apk-apps-manager'); ?></li>
                                <li><strong><?php esc_html_e('Download Count:', 'arewa-apk-apps-manager'); ?></strong> <?php esc_html_e('Automatically includes download count in structured data.', 'arewa-apk-apps-manager'); ?></li>
                            </ul>
                        </td>
                    </tr>
                    <?php if ($seo_plugin_active): ?>
                    <tr>
                        <th scope="row"><?php esc_html_e('SEO Plugin Compatibility', 'arewa-apk-apps-manager'); ?></th>
                        <td>
                            <p>
                                <span style="color: green; font-weight: bold;">✓ <?php echo esc_html($seo_plugin_name); ?> <?php esc_html_e('is active', 'arewa-apk-apps-manager'); ?></span>
                            </p>
                            <p>
                                <strong><?php esc_html_e('How They Work Together:', 'arewa-apk-apps-manager'); ?></strong>
                            </p>
                            <ul style="list-style: disc; margin-left: 20px;">
                                <li><?php esc_html_e('Your SEO plugin handles Article schema and general page SEO', 'arewa-apk-apps-manager'); ?></li>
                                <li><?php esc_html_e('This plugin adds SoftwareApplication schema for the mobile app', 'arewa-apk-apps-manager'); ?></li>
                                <li><?php esc_html_e('Both schemas can coexist on the same page without conflicts', 'arewa-apk-apps-manager'); ?></li>
                                <li><?php esc_html_e('This plugin does NOT add Open Graph/Twitter tags when a SEO plugin is detected (to avoid conflicts)', 'arewa-apk-apps-manager'); ?></li>
                            </ul>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <th scope="row"><?php esc_html_e('Verify SEO', 'arewa-apk-apps-manager'); ?></th>
                        <td>
                            <p>
                                <?php esc_html_e('To verify that SEO meta tags are working correctly:', 'arewa-apk-apps-manager'); ?>
                            </p>
                            <ul style="list-style: disc; margin-left: 20px;">
                                <li><?php esc_html_e('View page source (Ctrl+U or Cmd+U) and search for "Arewa APK App SEO Meta Tags"', 'arewa-apk-apps-manager'); ?></li>
                                <li><?php esc_html_e('Use Google Rich Results Test:', 'arewa-apk-apps-manager'); ?> <a href="<?php echo esc_url('https://search.google.com/test/rich-results'); ?>" target="_blank">https://search.google.com/test/rich-results</a></li>
                                <li><?php esc_html_e('Use Facebook Sharing Debugger:', 'arewa-apk-apps-manager'); ?> <a href="<?php echo esc_url('https://developers.facebook.com/tools/debug/'); ?>" target="_blank">https://developers.facebook.com/tools/debug/</a></li>
                                <li><?php esc_html_e('Use Twitter Card Validator:', 'arewa-apk-apps-manager'); ?> <a href="<?php echo esc_url('https://cards-dev.twitter.com/validator'); ?>" target="_blank">https://cards-dev.twitter.com/validator</a></li>
                            </ul>
                        </td>
                    </tr>
                </table>
            </div>
            
            <div class="arewa-apk-settings-section">
                <h2><?php esc_html_e('Shortcode', 'arewa-apk-apps-manager'); ?></h2>
                
                <h3><?php esc_html_e('Display Single App', 'arewa-apk-apps-manager'); ?></h3>
                <p><?php esc_html_e('Use the following shortcode to display a single app on any page or post:', 'arewa-apk-apps-manager'); ?></p>
                <code style="display: block; padding: 10px; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; margin: 10px 0;">[arewa_apk_app]</code>
                <p class="description"><?php esc_html_e('For legacy single-app mode, this will display the app configured in legacy settings. For multi-app mode, use:', 'arewa-apk-apps-manager'); ?></p>
                <code style="display: block; padding: 10px; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; margin: 10px 0;">[arewa_apk_app id="123"]</code>
                <p class="description"><?php esc_html_e('Or use the app slug:', 'arewa-apk-apps-manager'); ?></p>
                <code style="display: block; padding: 10px; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; margin: 10px 0;">[arewa_apk_app slug="my-app"]</code>
                
                <h3 style="margin-top: 30px;"><?php esc_html_e('Display Apps List/Archive', 'arewa-apk-apps-manager'); ?></h3>
                <p><?php esc_html_e('Use the following shortcode to display a list of all apps:', 'arewa-apk-apps-manager'); ?></p>
                <code style="display: block; padding: 10px; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; margin: 10px 0;">[arewa_apk_app display="list"]</code>
                <p class="description"><?php esc_html_e('Or use:', 'arewa-apk-apps-manager'); ?></p>
                <code style="display: block; padding: 10px; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; margin: 10px 0;">[arewa_apk_app display="archive"]</code>
                
                <h3 style="margin-top: 30px;"><?php esc_html_e('Display Apps Carousel', 'arewa-apk-apps-manager'); ?></h3>
                <p><?php esc_html_e('Use the following shortcode to display apps in a horizontal carousel format:', 'arewa-apk-apps-manager'); ?></p>
                <code style="display: block; padding: 10px; background: #f5f5f5; border: 1px solid #ddd; border-radius: 4px; margin: 10px 0;">[arewa_apk_app display="carousel"]</code>
                <p class="description"><?php esc_html_e('The carousel uses the Feature Graphic image as the featured image for each app. If no Feature Graphic is set, it will use the App Icon instead.', 'arewa-apk-apps-manager'); ?></p>
                
                <h3 style="margin-top: 30px;"><?php esc_html_e('Shortcode Attributes', 'arewa-apk-apps-manager'); ?></h3>
                <p class="description"><?php esc_html_e('For single app display:', 'arewa-apk-apps-manager'); ?></p>
                <ul style="list-style: disc; margin-left: 20px;">
                    <li><code>id="123"</code> - <?php esc_html_e('Display a specific app by ID', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>slug="my-app"</code> - <?php esc_html_e('Display a specific app by slug', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>show_icon="yes"</code> - <?php esc_html_e('Show app icon (yes/no)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>show_screenshot="yes"</code> - <?php esc_html_e('Show screenshot (yes/no)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>show_version="yes"</code> - <?php esc_html_e('Show version (yes/no)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>show_comments="yes"</code> - <?php esc_html_e('Show comments section (yes/no)', 'arewa-apk-apps-manager'); ?></li>
                </ul>
                
                <p class="description" style="margin-top: 20px;"><?php esc_html_e('For apps list/archive display:', 'arewa-apk-apps-manager'); ?></p>
                <ul style="list-style: disc; margin-left: 20px;">
                    <li><code>display="list"</code> o <code>display="archive"</code> - <?php esc_html_e('Display the list of apps instead of a single app', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>category="video-player"</code> - <?php esc_html_e('Filter apps by category slug (optional)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>posts_per_page="12"</code> - <?php esc_html_e('Number of apps to display per page (optional, defaults to plugin settings)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>title="My Apps"</code> - <?php esc_html_e('Custom title for the archive page (optional)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>description="Custom description"</code> - <?php esc_html_e('Custom description for the archive page (optional)', 'arewa-apk-apps-manager'); ?></li>
                </ul>
                
                <p class="description" style="margin-top: 20px;"><?php esc_html_e('For apps carousel display:', 'arewa-apk-apps-manager'); ?></p>
                <ul style="list-style: disc; margin-left: 20px;">
                    <li><code>display="carousel"</code> - <?php esc_html_e('Display apps in a horizontal carousel format', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>limit="10"</code> - <?php esc_html_e('Number of apps to display in carousel (optional, defaults to 12). This is the recommended attribute for carousel.', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>posts_per_page="10"</code> - <?php esc_html_e('Alternative to limit, same functionality. Number of apps to display in carousel (optional, defaults to 12)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>category="video-player"</code> - <?php esc_html_e('Filter apps by category slug (optional)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>title="Recommended for you"</code> - <?php esc_html_e('Custom title for the carousel (optional, defaults to "Recommended for you")', 'arewa-apk-apps-manager'); ?></li>
                </ul>
                
                <h3 style="margin-top: 30px;"><?php esc_html_e('Examples', 'arewa-apk-apps-manager'); ?></h3>
                <p class="description"><strong><?php esc_html_e('Single App Examples:', 'arewa-apk-apps-manager'); ?></strong></p>
                <ul style="list-style: disc; margin-left: 20px; margin-bottom: 20px;">
                    <li><code>[arewa_apk_app]</code> - <?php esc_html_e('Display current app (if on single app page) or legacy app', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app id="123"]</code> - <?php esc_html_e('Display app with ID 123', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app slug="my-app"]</code> - <?php esc_html_e('Display app with slug "my-app"', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app id="123" show_comments="no"]</code> - <?php esc_html_e('Display app without comments section', 'arewa-apk-apps-manager'); ?></li>
                </ul>
                
                <p class="description"><strong><?php esc_html_e('Apps List Examples:', 'arewa-apk-apps-manager'); ?></strong></p>
                <ul style="list-style: disc; margin-left: 20px; margin-bottom: 20px;">
                    <li><code>[arewa_apk_app display="list"]</code> - <?php esc_html_e('Display all apps in a list', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="list" category="video-player"]</code> - <?php esc_html_e('Display only apps from "video-player" category', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="list" posts_per_page="12" title="Featured Apps"]</code> - <?php esc_html_e('Display 12 apps per page with custom title', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="list" posts_per_page="16" title="Featured Apps" has_pagination="no"] </code> - <?php esc_html_e('Display 16 apps per page with custom title without pagination', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="archive" category="movies" posts_per_page="6"]</code> - <?php esc_html_e('Display 6 apps from "movies" category per page', 'arewa-apk-apps-manager'); ?></li>
                </ul>
                
                <p class="description"><strong><?php esc_html_e('Apps Carousel Examples:', 'arewa-apk-apps-manager'); ?></strong></p>
                <ul style="list-style: disc; margin-left: 20px; margin-bottom: 20px;">
                    <li><code>[arewa_apk_app display="carousel"]</code> - <?php esc_html_e('Display apps in carousel format (default: 12 apps)', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="carousel" limit="10"]</code> - <?php esc_html_e('Display 10 apps in carousel format', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="carousel" limit="10" title="Featured Apps"]</code> - <?php esc_html_e('Display 10 apps with custom title', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="carousel" category="games" limit="8"]</code> - <?php esc_html_e('Display 8 apps from "games" category in carousel', 'arewa-apk-apps-manager'); ?></li>
                    <li><code>[arewa_apk_app display="carousel" category="games" posts_per_page="8"]</code> - <?php esc_html_e('Alternative: Display 8 apps from "games" category using posts_per_page', 'arewa-apk-apps-manager'); ?></li>
                </ul>
                
                <p class="description">
                    <strong><?php esc_html_e('Note:', 'arewa-apk-apps-manager'); ?></strong>
                    <?php esc_html_e('SEO meta tags and structured data are automatically added when the shortcode is used on a page.', 'arewa-apk-apps-manager'); ?>
                </p>
            </div>
        </div>
        
        <?php submit_button(esc_html__('Save Settings', 'arewa-apk-apps-manager'), 'primary', 'arewa_apk_save_plugin_settings'); ?>
    </form>
</div>
