<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Elementor Widget for Arewa APK App
 */
class Arewa_APK_Elementor_Widget extends \Elementor\Widget_Base {
    
    public function get_name() {
        return 'arewa_apk_app';
    }
    
    public function get_title() {
        return __('Arewa APK App', 'arewa-apk-apps-manager');
    }
    
    public function get_icon() {
        return 'eicon-apps';
    }
    
    public function get_categories() {
        return ['general'];
    }
    
    public function get_keywords() {
        return ['apk', 'app', 'download', 'android', 'arewa'];
    }
    
    protected function register_controls() {
        
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Archive Display Options', 'arewa-apk-apps-manager'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'archive_title',
            [
                'label' => __('Archive Title', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('APK Apps', 'arewa-apk-apps-manager'),
                'placeholder' => __('Enter archive title', 'arewa-apk-apps-manager'),
            ]
        );
        
        $this->add_control(
            'archive_description',
            [
                'label' => __('Archive Description', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => '',
                'placeholder' => __('Enter archive description (optional)', 'arewa-apk-apps-manager'),
            ]
        );
        
        $this->add_control(
            'category',
            [
                'label' => __('Category Filter', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '',
                'placeholder' => __('Enter category slug (optional)', 'arewa-apk-apps-manager'),
                'description' => __('Filter apps by category slug. Leave empty to show all apps.', 'arewa-apk-apps-manager'),
            ]
        );
        
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min' => 1,
                'max' => 100,
                'description' => __('Number of apps to display per page. Leave empty to use plugin default.', 'arewa-apk-apps-manager'),
            ]
        );
        
        $this->end_controls_section();
        
        // Style Section - Archive Header
        $this->start_controls_section(
            'style_header_section',
            [
                'label' => __('Archive Header Style', 'arewa-apk-apps-manager'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'header_title_color',
            [
                'label' => __('Title Color', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arewa-apk-archive-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'header_description_color',
            [
                'label' => __('Description Color', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arewa-apk-archive-description' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // Style Section - Archive Items
        $this->start_controls_section(
            'style_items_section',
            [
                'label' => __('Archive Items Style', 'arewa-apk-apps-manager'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'item_background',
            [
                'label' => __('Item Background Color', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arewa-apk-archive-item' => 'background: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'item_title_color',
            [
                'label' => __('App Title Color', 'arewa-apk-apps-manager'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .arewa-apk-archive-item-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings = $this->get_settings_for_display();
        
        // Build shortcode attributes for archive/list display
        $shortcode_atts = array('display' => 'list');
        
        if (!empty($settings['archive_title'])) {
            $shortcode_atts['title'] = $settings['archive_title'];
        }
        
        if (!empty($settings['archive_description'])) {
            $shortcode_atts['description'] = $settings['archive_description'];
        }
        
        if (!empty($settings['category'])) {
            $shortcode_atts['category'] = $settings['category'];
        }
        
        if (!empty($settings['posts_per_page'])) {
            $shortcode_atts['posts_per_page'] = absint($settings['posts_per_page']);
        }
        
        // Build shortcode string
        $shortcode_string = '[arewa_apk_app display="list"';
        
        if (!empty($shortcode_atts['title'])) {
            $shortcode_string .= ' title="' . esc_attr($shortcode_atts['title']) . '"';
        }
        
        if (!empty($shortcode_atts['description'])) {
            $shortcode_string .= ' description="' . esc_attr($shortcode_atts['description']) . '"';
        }
        
        if (!empty($shortcode_atts['category'])) {
            $shortcode_string .= ' category="' . esc_attr($shortcode_atts['category']) . '"';
        }
        
        if (!empty($shortcode_atts['posts_per_page'])) {
            $shortcode_string .= ' posts_per_page="' . esc_attr($shortcode_atts['posts_per_page']) . '"';
        }
        
        $shortcode_string .= ']';
        
        // Render the shortcode content
        echo do_shortcode($shortcode_string);
    }
    
    protected function content_template() {
        // Template for Elementor editor preview (optional)
    }
}

