<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get plugin settings for archive display
$plugin_settings = Arewa_APK_App::get_plugin_settings();
$show_download_button = $plugin_settings['show_download_button'] ?? 'no';
$show_short_description = $plugin_settings['show_short_description'] ?? 'no';
$show_categories = $plugin_settings['show_categories'] ?? 'no';
$show_version = $plugin_settings['show_version'] ?? 'no';
$show_last_updated = $plugin_settings['show_last_updated'] ?? 'no';
$show_download_count = $plugin_settings['show_download_count'] ?? 'no';
$show_rating = $plugin_settings['show_rating'] ?? 'yes';
$show_excerpt = $plugin_settings['show_excerpt'] ?? 'no';

// Get posts per page from settings - use the same as archive page
$posts_per_page = absint($plugin_settings['posts_per_page'] ?? get_option('posts_per_page', 10));

// Get query args from shortcode attributes
$arewa_apk_current_category = isset($atts['category']) ? sanitize_text_field($atts['category']) : '';
// Only use shortcode posts_per_page if explicitly set, otherwise use plugin settings
$posts_per_page_attr = isset($atts['posts_per_page']) && !empty($atts['posts_per_page']) ? absint($atts['posts_per_page']) : $posts_per_page;

// Get has_pagination attribute (default: 'yes')
$has_pagination = isset($atts['has_pagination']) ? strtolower($atts['has_pagination']) : 'yes';
$has_pagination = ($has_pagination === 'no' || $has_pagination === 'false' || $has_pagination === '0') ? 'no' : 'yes';

// Setup query args
$query_args = array(
    'post_type' => 'arewa_apk_app',
    'post_status' => 'publish',
    'posts_per_page' => $posts_per_page_attr,
    'paged' => ($has_pagination === 'no') ? 1 : (get_query_var('paged') ? get_query_var('paged') : 1),
);

// Add category filter if specified
if (!empty($arewa_apk_current_category)) {
    // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query
    // tax_query is necessary for filtering apps by category
    $query_args['tax_query'] = array(
        array(
            'taxonomy' => 'arewa_apk_category',
            'field' => 'slug',
            'terms' => $arewa_apk_current_category,
        ),
    );
}

// Create custom query
$apps_query = new WP_Query($query_args);

// Get title from shortcode or use default
$arewa_apk_archive_title = isset($atts['title']) ? sanitize_text_field($atts['title']) : __('APK Apps', 'arewa-apk-apps-manager');
$arewa_apk_archive_description = isset($atts['description']) ? wp_kses_post($atts['description']) : '';
?>

<div class="arewa-apk-archive-wrapper" style="width: 100% !important; max-width: 100% !important; margin-left: 0 !important; margin-right: 0 !important; margin-top: 0 !important; margin-bottom: 0 !important; padding: 0 !important; clear: both !important; float: none !important; display: block !important; box-sizing: border-box !important; position: relative !important; left: 0 !important; right: 0 !important; transform: none !important;">
<div class="arewa-apk-archive-container" style="max-width: 1400px !important; margin-left: auto !important; margin-right: auto !important; margin-top: 0 !important; margin-bottom: 0 !important; padding: 0 !important; width: 100% !important; box-sizing: border-box !important; clear: both !important; float: none !important; display: block !important; position: relative !important; left: auto !important; right: auto !important; transform: none !important;">
    <?php if (!empty($arewa_apk_archive_title)) : ?>
    <header class="arewa-apk-archive-header">
        <h1 class="arewa-apk-archive-title"><?php echo esc_html($arewa_apk_archive_title); ?></h1>
        <?php if (!empty($arewa_apk_archive_description)) : ?>
            <div class="arewa-apk-archive-description"><?php echo wp_kses_post($arewa_apk_archive_description); ?></div>
        <?php endif; ?>
    </header>
    <?php endif; ?>

    <?php if ($apps_query->have_posts()) : ?>
        <div class="arewa-apk-archive-list">
            <?php while ($apps_query->have_posts()) : $apps_query->the_post(); ?>
                <?php
                $arewa_apk_app_id = get_the_ID();
                $arewa_apk_app_name = get_the_title();
                $arewa_apk_app_version = get_post_meta($arewa_apk_app_id, '_arewa_apk_version', true) ?: '1.0.0';
                $arewa_apk_app_icon = get_post_meta($arewa_apk_app_id, '_arewa_apk_icon', true);
                if (empty($arewa_apk_app_icon) && has_post_thumbnail()) {
                    $arewa_apk_app_icon = get_the_post_thumbnail_url($arewa_apk_app_id, 'medium');
                }
                $arewa_apk_apk_url = get_post_meta($arewa_apk_app_id, '_arewa_apk_url', true);
                $arewa_apk_short_description = get_post_meta($arewa_apk_app_id, '_arewa_apk_short_description', true);
                $arewa_apk_download_count = absint(get_post_meta($arewa_apk_app_id, '_arewa_apk_download_count', true) ?: 0);
                $arewa_apk_average_rating = Arewa_APK_App::get_average_rating($arewa_apk_app_id);
                $arewa_apk_rating_count = Arewa_APK_App::get_rating_count($arewa_apk_app_id);
                // Get last modified date instead of publish date - format as "12, 27, 2025"
                $arewa_apk_modified_date = get_the_modified_date('U');
                $arewa_apk_last_updated = gmdate('n, j, Y', $arewa_apk_modified_date);
                ?>
                <article class="arewa-apk-archive-item" data-app-id="<?php echo esc_attr($arewa_apk_app_id); ?>">
                    <a href="<?php the_permalink(); ?>" class="arewa-apk-archive-item-link">
                        <?php if ($arewa_apk_app_icon) : ?>
                            <div class="arewa-apk-archive-icon">
                                <img src="<?php echo esc_url($arewa_apk_app_icon); ?>" alt="<?php echo esc_attr($arewa_apk_app_name); ?>" />
                            </div>
                        <?php else: ?>
                            <div class="arewa-apk-archive-icon arewa-apk-archive-icon-placeholder">
                                <span class="dashicons dashicons-smartphone"></span>
                            </div>
                        <?php endif; ?>
                        
                        <div class="arewa-apk-archive-content">
                            <h3 class="arewa-apk-archive-item-title"><?php echo esc_html($arewa_apk_app_name); ?></h3>
                            
                            <?php if ($show_version === 'yes' || $show_last_updated === 'yes' || ($show_download_count === 'yes' && $arewa_apk_download_count > 0)) : ?>
                                <div class="arewa-apk-archive-meta">
                                    <?php if ($show_version === 'yes') : ?>
                                        <span class="arewa-apk-archive-version"><?php echo esc_html($arewa_apk_app_version); ?></span>
                                    <?php endif; ?>
                                    <?php if ($show_last_updated === 'yes') : ?>
                                        <span class="arewa-apk-archive-date"><?php echo esc_html($arewa_apk_last_updated); ?></span>
                                    <?php endif; ?>
                                    <?php if ($show_download_count === 'yes' && $arewa_apk_download_count > 0) : ?>
                                        <span class="arewa-apk-archive-downloads"><?php
                                        // translators: %s: Number of downloads
                                        echo esc_html(sprintf(_n('%s download', '%s downloads', $arewa_apk_download_count, 'arewa-apk-apps-manager'), number_format_i18n($arewa_apk_download_count)));
                                        ?></span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_short_description === 'yes' && !empty($arewa_apk_short_description)) : ?>
                                <div class="arewa-apk-archive-short-description">
                                    <?php echo esc_html($arewa_apk_short_description); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_rating === 'yes') : ?>
                                <div class="arewa-apk-archive-rating">
                                    <?php if ($arewa_apk_average_rating > 0 && $arewa_apk_rating_count > 0) : ?>
                                        <span class="arewa-rating-stars-inline">
                                            <?php 
                                            $arewa_apk_full_stars = floor($arewa_apk_average_rating);
                                            $arewa_apk_has_half = ($arewa_apk_average_rating - $arewa_apk_full_stars) >= 0.5;
                                            for ($arewa_apk_i = 1; $arewa_apk_i <= 5; $arewa_apk_i++): 
                                                if ($arewa_apk_i <= $arewa_apk_full_stars): ?>
                                                    <span class="arewa-star arewa-star-filled">★</span>
                                                <?php elseif ($arewa_apk_i == $arewa_apk_full_stars + 1 && $arewa_apk_has_half): ?>
                                                    <span class="arewa-star arewa-star-half">★</span>
                                                <?php else: ?>
                                                    <span class="arewa-star arewa-star-empty">☆</span>
                                                <?php endif;
                                            endfor; ?>
                                        </span>
                                        <span class="arewa-rating-value"><?php echo esc_html(number_format_i18n($arewa_apk_average_rating, 1)); ?></span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_excerpt === 'yes' && has_excerpt()) : ?>
                                <div class="arewa-apk-archive-excerpt">
                                    <?php the_excerpt(); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_categories === 'yes') : ?>
                                <?php 
                                $arewa_apk_categories = get_the_terms($arewa_apk_app_id, 'arewa_apk_category');
                                if ($arewa_apk_categories && !is_wp_error($arewa_apk_categories) && !empty($arewa_apk_categories)): ?>
                                    <div class="arewa-apk-archive-categories">
                                        <?php 
                                        $arewa_apk_category_count = 0;
                                        foreach ($arewa_apk_categories as $arewa_apk_category) : 
                                            if ($arewa_apk_category_count >= 5) break;
                                        ?>
                                            <a href="<?php echo esc_url(get_term_link($arewa_apk_category)); ?>" class="arewa-apk-category-tag">
                                                <?php echo esc_html($arewa_apk_category->name); ?>
                                            </a>
                                        <?php 
                                            $arewa_apk_category_count++;
                                        endforeach; 
                                        ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <?php if ($show_download_button === 'yes' && $arewa_apk_apk_url) : ?>
                                <div class="arewa-apk-archive-actions">
                                    <a href="<?php echo esc_url($arewa_apk_apk_url); ?>" class="arewa-apk-archive-download-btn" download data-apk-url="<?php echo esc_url($arewa_apk_apk_url); ?>" data-app-id="<?php echo esc_attr($arewa_apk_app_id); ?>">
                                        <?php esc_html_e('Download', 'arewa-apk-apps-manager'); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </a>
                </article>
            <?php endwhile; ?>
        </div>
        
        <?php
        // Pagination - only show if has_pagination is 'yes'
        if ($has_pagination === 'yes') {
            $arewa_apk_pagination_args = array(
                'total' => $apps_query->max_num_pages,
                'current' => max(1, get_query_var('paged')),
                'prev_text' => __('&laquo; Previous', 'arewa-apk-apps-manager'),
                'next_text' => __('Next &raquo;', 'arewa-apk-apps-manager'),
            );
            
            // Only show pagination if there are multiple pages
            if ($apps_query->max_num_pages > 1) {
                $pagination_links = paginate_links($arewa_apk_pagination_args);
                if ($pagination_links) {
                    echo '<div class="arewa-apk-pagination">';
                    echo wp_kses_post($pagination_links);
                    echo '</div>';
                }
            }
        }
        ?>
        
        <?php wp_reset_postdata(); ?>
    <?php else : ?>
        <div class="arewa-apk-archive-empty">
            <p><?php esc_html_e('No apps found.', 'arewa-apk-apps-manager'); ?></p>
        </div>
    <?php endif; ?>
</div>
</div>

<?php
// Archive styles are now enqueued via wp_enqueue_style in enqueue_frontend_assets()
?>

