<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get plugin settings for archive display
$plugin_settings = Arewa_APK_App::get_plugin_settings();
$show_download_button = $plugin_settings['show_download_button'] ?? 'yes';
$show_short_description = $plugin_settings['show_short_description'] ?? 'yes';
$show_categories = $plugin_settings['show_categories'] ?? 'yes';
$show_version = $plugin_settings['show_version'] ?? 'yes';
$show_last_updated = $plugin_settings['show_last_updated'] ?? 'yes';
$show_download_count = $plugin_settings['show_download_count'] ?? 'yes';
$show_rating = $plugin_settings['show_rating'] ?? 'yes';

// Get posts per page from shortcode attributes - support both 'limit' and 'posts_per_page'
// Priority: limit > posts_per_page > default (12)
$posts_per_page = 12; // Default value
if (isset($atts['limit']) && !empty($atts['limit'])) {
    $posts_per_page = absint($atts['limit']);
} elseif (isset($atts['posts_per_page']) && !empty($atts['posts_per_page'])) {
    $posts_per_page = absint($atts['posts_per_page']);
}

// Get query args from shortcode attributes
$category = isset($atts['category']) ? sanitize_text_field($atts['category']) : '';
$title = isset($atts['title']) ? sanitize_text_field($atts['title']) : __('Recommended for you', 'arewa-apk-apps-manager');

// Setup query args
$query_args = array(
    'post_type' => 'arewa_apk_app',
    'post_status' => 'publish',
    'posts_per_page' => $posts_per_page,
    'paged' => 1,
);

// Add category filter if specified
if (!empty($category)) {
    // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query
    // tax_query is necessary for filtering apps by category
    $query_args['tax_query'] = array(
        array(
            'taxonomy' => 'arewa_apk_category',
            'field' => 'slug',
            'terms' => $category,
        ),
    );
}

// Create custom query
$apps_query = new WP_Query($query_args);
?>

<div class="arewa-apk-carousel-wrapper">
    <?php if (!empty($title)) : ?>
    <h2 class="arewa-apk-carousel-title"><?php echo esc_html($title); ?></h2>
    <?php endif; ?>
    
    <?php if ($apps_query->have_posts()) : ?>
        <div class="arewa-apk-carousel-container" style="width: 100%; max-width: 100%; box-sizing: border-box;">
            <button class="arewa-apk-carousel-nav arewa-apk-carousel-prev" aria-label="<?php esc_attr_e('Previous', 'arewa-apk-apps-manager'); ?>">
                <span class="dashicons dashicons-arrow-left-alt2"></span>
            </button>
            
            <div class="arewa-apk-carousel-track">
                <div class="arewa-apk-carousel-slides">
                    <?php while ($apps_query->have_posts()) : $apps_query->the_post(); ?>
                        <?php
                        $app_id = get_the_ID();
                        $app_name = get_the_title();
                        $app_version = get_post_meta($app_id, '_arewa_apk_version', true) ?: '1.0.0';
                        $app_icon = get_post_meta($app_id, '_arewa_apk_icon', true);
                        $feature_graphic = get_post_meta($app_id, '_arewa_apk_feature_graphic', true);
                        // Use feature graphic as featured image, fallback to icon
                        $featured_image = !empty($feature_graphic) ? $feature_graphic : $app_icon;
                        if (empty($featured_image) && has_post_thumbnail()) {
                            $featured_image = get_the_post_thumbnail_url($app_id, 'large');
                        }
                        $apk_url = get_post_meta($app_id, '_arewa_apk_url', true);
                        $short_description = get_post_meta($app_id, '_arewa_apk_short_description', true);
                        $download_count = absint(get_post_meta($app_id, '_arewa_apk_download_count', true) ?: 0);
                        $average_rating = Arewa_APK_App::get_average_rating($app_id);
                        $rating_count = Arewa_APK_App::get_rating_count($app_id);
                        ?>
                        <div class="arewa-apk-carousel-slide">
                            <article class="arewa-apk-carousel-item" <?php if ($featured_image) : ?>style="background-image: url('<?php echo esc_url($featured_image); ?>');"<?php endif; ?>>
                                <div class="arewa-apk-carousel-overlay"></div>
                                
                                <a href="<?php the_permalink(); ?>" class="arewa-apk-carousel-link">
                                    <div class="arewa-apk-carousel-content">
                                        <?php if ($app_icon) : ?>
                                            <div class="arewa-apk-carousel-icon">
                                                <img src="<?php echo esc_url($app_icon); ?>" alt="<?php echo esc_attr($app_name); ?>" />
                                            </div>
                                        <?php endif; ?>
                                        
                                        <h3 class="arewa-apk-carousel-app-name"><?php echo esc_html($app_name); ?></h3>
                                        
                                        <?php if (!empty($short_description)) : ?>
                                            <div class="arewa-apk-carousel-short-description">
                                                <?php echo esc_html($short_description); ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if ($show_rating === 'yes') : ?>
                                            <div class="arewa-apk-carousel-rating">
                                                <?php if ($average_rating > 0 && $rating_count > 0) : ?>
                                                    <span class="arewa-rating-stars">
                                                        <?php 
                                                        $full_stars = floor($average_rating);
                                                        $has_half = ($average_rating - $full_stars) >= 0.5;
                                                        for ($i = 1; $i <= 5; $i++): 
                                                            if ($i <= $full_stars): ?>
                                                                <span class="arewa-star arewa-star-filled">★</span>
                                                            <?php elseif ($i == $full_stars + 1 && $has_half): ?>
                                                                <span class="arewa-star arewa-star-half">★</span>
                                                            <?php else: ?>
                                                                <span class="arewa-star arewa-star-empty">☆</span>
                                                            <?php endif;
                                                        endfor; ?>
                                                    </span>
                                                    <span class="arewa-rating-value"><?php echo esc_html(number_format_i18n($average_rating, 1)); ?>★</span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if ($show_categories === 'yes') : ?>
                                            <?php 
                                            $categories = get_the_terms($app_id, 'arewa_apk_category');
                                            if ($categories && !is_wp_error($categories) && !empty($categories)): 
                                                $category_names = array();
                                                $category_count = 0;
                                                foreach ($categories as $category) : 
                                                    if ($category_count >= 2) break; // Limit to 2 categories
                                                    $category_names[] = $category->name;
                                                    $category_count++;
                                                endforeach;
                                                if (!empty($category_names)):
                                            ?>
                                                <div class="arewa-apk-carousel-genre">
                                                    <?php echo esc_html(implode(' • ', $category_names)); ?>
                                                </div>
                                            <?php 
                                                endif;
                                            endif; 
                                            ?>
                                        <?php endif; ?>
                                        
                                        <?php if ($show_download_button === 'yes' && $apk_url) : ?>
                                            <a href="<?php echo esc_url($apk_url); ?>" class="arewa-apk-carousel-download-btn" download data-apk-url="<?php echo esc_url($apk_url); ?>" data-app-id="<?php echo esc_attr($app_id); ?>" onclick="event.stopPropagation();">
                                                <?php esc_html_e('Download', 'arewa-apk-apps-manager'); ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </article>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
            
            <button class="arewa-apk-carousel-nav arewa-apk-carousel-next" aria-label="<?php esc_attr_e('Next', 'arewa-apk-apps-manager'); ?>">
                <span class="dashicons dashicons-arrow-right-alt2"></span>
            </button>
        </div>
        
        <?php wp_reset_postdata(); ?>
    <?php else : ?>
        <div class="arewa-apk-carousel-empty">
            <p><?php esc_html_e('No apps found.', 'arewa-apk-apps-manager'); ?></p>
        </div>
    <?php endif; ?>
</div>

<?php
// Carousel styles and scripts are now enqueued via wp_enqueue_style/wp_enqueue_script in enqueue_frontend_assets()
?>

