<?php
/**
 * Template for displaying archive pages for APK Apps
 *
 * @package Arewa_APK_App
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

get_header();

// Get plugin settings for archive display
$plugin_settings = Arewa_APK_App::get_plugin_settings();
$show_download_button = $plugin_settings['show_download_button'] ?? 'no';
$show_short_description = $plugin_settings['show_short_description'] ?? 'no';
$show_categories = $plugin_settings['show_categories'] ?? 'no';
$show_version = $plugin_settings['show_version'] ?? 'no';
$show_last_updated = $plugin_settings['show_last_updated'] ?? 'no';
$show_download_count = $plugin_settings['show_download_count'] ?? 'no';
$show_rating = $plugin_settings['show_rating'] ?? 'yes';
$show_excerpt = $plugin_settings['show_excerpt'] ?? 'no';
?>

<div class="arewa-apk-archive-container" style="max-width: 1400px !important; margin-left: auto !important; margin-right: auto !important; width: 100% !important; box-sizing: border-box !important; clear: both !important; float: none !important; display: block !important; position: relative !important; left: 0 !important; right: 0 !important; transform: none !important;">
    <header class="arewa-apk-archive-header">
        <h1 class="arewa-apk-archive-title"><?php post_type_archive_title(); ?></h1>
        <?php
        $description = get_the_archive_description();
        if ($description) {
            echo '<div class="arewa-apk-archive-description">' . wp_kses_post($description) . '</div>';
        }
        ?>
    </header>

    <?php if (have_posts()) : ?>
        <div class="arewa-apk-archive-list">
            <?php while (have_posts()) : the_post(); ?>
                <?php
                $app_id = get_the_ID();
                $app_name = get_the_title();
                $app_version = get_post_meta($app_id, '_arewa_apk_version', true) ?: '1.0.0';
                $app_icon = get_post_meta($app_id, '_arewa_apk_icon', true);
                if (empty($app_icon) && has_post_thumbnail()) {
                    $app_icon = get_the_post_thumbnail_url($app_id, 'medium');
                }
                $apk_url = get_post_meta($app_id, '_arewa_apk_url', true);
                $short_description = get_post_meta($app_id, '_arewa_apk_short_description', true);
                $download_count = absint(get_post_meta($app_id, '_arewa_apk_download_count', true) ?: 0);
                $average_rating = Arewa_APK_App::get_average_rating($app_id);
                $rating_count = Arewa_APK_App::get_rating_count($app_id);
                // Get last modified date instead of publish date - format as "12, 27, 2025"
                $modified_date = get_the_modified_date('U');
                $last_updated = gmdate('n, j, Y', $modified_date);
                ?>
                <article class="arewa-apk-archive-item" data-app-id="<?php echo esc_attr($app_id); ?>">
                    <a href="<?php the_permalink(); ?>" class="arewa-apk-archive-item-link">
                        <?php if ($app_icon) : ?>
                            <div class="arewa-apk-archive-icon">
                                <img src="<?php echo esc_url($app_icon); ?>" alt="<?php echo esc_attr($app_name); ?>" />
                            </div>
                        <?php else: ?>
                            <div class="arewa-apk-archive-icon arewa-apk-archive-icon-placeholder">
                                <span class="dashicons dashicons-smartphone"></span>
                            </div>
                        <?php endif; ?>
                        
                        <div class="arewa-apk-archive-content">
                            <h3 class="arewa-apk-archive-item-title"><?php echo esc_html($app_name); ?></h3>
                            
                            <?php if ($show_version === 'yes' || $show_last_updated === 'yes' || ($show_download_count === 'yes' && $download_count > 0)) : ?>
                                <div class="arewa-apk-archive-meta">
                                    <?php if ($show_version === 'yes') : ?>
                                        <span class="arewa-apk-archive-version"><?php echo esc_html($app_version); ?></span>
                                    <?php endif; ?>
                                    <?php if ($show_last_updated === 'yes') : ?>
                                        <span class="arewa-apk-archive-date"><?php echo esc_html($last_updated); ?></span>
                                    <?php endif; ?>
                                    <?php if ($show_download_count === 'yes' && $download_count > 0) : ?>
                                        <span class="arewa-apk-archive-downloads"><?php
                                        // translators: %s: Number of downloads
                                        echo esc_html(sprintf(_n('%s download', '%s downloads', $download_count, 'arewa-apk-apps-manager'), number_format_i18n($download_count)));
                                        ?></span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_short_description === 'yes' && !empty($short_description)) : ?>
                                <div class="arewa-apk-archive-short-description">
                                    <?php echo esc_html($short_description); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_rating === 'yes') : ?>
                                <div class="arewa-apk-archive-rating">
                                    <?php if ($average_rating > 0 && $rating_count > 0) : ?>
                                        <span class="arewa-rating-stars-inline">
                                            <?php 
                                            $full_stars = floor($average_rating);
                                            $has_half = ($average_rating - $full_stars) >= 0.5;
                                            for ($i = 1; $i <= 5; $i++): 
                                                if ($i <= $full_stars): ?>
                                                    <span class="arewa-star arewa-star-filled">★</span>
                                                <?php elseif ($i == $full_stars + 1 && $has_half): ?>
                                                    <span class="arewa-star arewa-star-half">★</span>
                                                <?php else: ?>
                                                    <span class="arewa-star arewa-star-empty">☆</span>
                                                <?php endif;
                                            endfor; ?>
                                        </span>
                                        <span class="arewa-rating-value"><?php echo esc_html(number_format_i18n($average_rating, 1)); ?></span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_excerpt === 'yes' && has_excerpt()) : ?>
                                <div class="arewa-apk-archive-excerpt">
                                    <?php the_excerpt(); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($show_categories === 'yes') : ?>
                                <?php 
                                $categories = get_the_terms($app_id, 'arewa_apk_category');
                                if ($categories && !is_wp_error($categories) && !empty($categories)): ?>
                                    <div class="arewa-apk-archive-categories">
                                        <?php 
                                        $category_count = 0;
                                        foreach ($categories as $category) : 
                                            if ($category_count >= 5) break;
                                        ?>
                                            <a href="<?php echo esc_url(get_term_link($category)); ?>" class="arewa-apk-category-tag">
                                                <?php echo esc_html($category->name); ?>
                                            </a>
                                        <?php 
                                            $category_count++;
                                        endforeach; 
                                        ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                            
                            <?php if ($show_download_button === 'yes' && $apk_url) : ?>
                                <div class="arewa-apk-archive-actions">
                                    <a href="<?php echo esc_url($apk_url); ?>" class="arewa-apk-archive-download-btn" download data-apk-url="<?php echo esc_url($apk_url); ?>" data-app-id="<?php echo esc_attr($app_id); ?>">
                                        <?php esc_html_e('Download', 'arewa-apk-apps-manager'); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </a>
                </article>
            <?php endwhile; ?>
        </div>
        
        <?php
        // Pagination
        global $wp_query;
        if ($wp_query->max_num_pages > 1) {
            $pagination_args = array(
                'total' => $wp_query->max_num_pages,
                'current' => max(1, get_query_var('paged')),
                'prev_text' => __('&laquo; Previous', 'arewa-apk-apps-manager'),
                'next_text' => __('Next &raquo;', 'arewa-apk-apps-manager'),
            );
            $pagination_links = paginate_links($pagination_args);
            if ($pagination_links) {
                echo '<div class="arewa-apk-pagination">';
                echo wp_kses_post($pagination_links);
                echo '</div>';
            }
        }
        ?>
    <?php else : ?>
        <div class="arewa-apk-archive-empty">
            <p><?php esc_html_e('No apps found.', 'arewa-apk-apps-manager'); ?></p>
        </div>
    <?php endif; ?>
</div>

<?php
// Archive styles are enqueued via wp_enqueue_style in enqueue_frontend_assets()
?>

<?php
get_footer();

