<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package Arewa_APK_App
 * 
 * This file is executed when the plugin is deleted from WordPress.
 * By default, this plugin preserves user data to prevent accidental data loss.
 * 
 * IMPORTANT: This file does NOT automatically delete plugin data by default.
 * This is intentional to preserve your settings, comments, and all data
 * when you deactivate, delete, or reinstall the plugin.
 * 
 * All your data (settings, comments, download counts) will be preserved
 * even after uninstalling and reinstalling the plugin.
 * 
 * If you want to completely remove all plugin data, uncomment the code below.
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// IMPORTANT: We do NOT delete data automatically to preserve user data
// when the plugin is deactivated, deleted, or reinstalled.
// 
// All data is preserved by design:
// - Settings (arewa_apk_settings) remain in wp_options
// - Plugin settings (arewa_apk_plugin_settings) remain in wp_options
// - Comments table (wp_arewa_apk_comments) remains in database
// - Download count (arewa_apk_download_count) remains in wp_options
// - All app posts and metadata remain in database
// - All categories and tags remain in database
//
// When you reinstall the plugin, all your data will be automatically restored.
//
// Uncomment the lines below ONLY if you want to permanently delete all data:

/*
// Delete plugin options
delete_option('arewa_apk_settings');
delete_option('arewa_apk_plugin_settings');
delete_option('arewa_apk_download_count');

// Drop custom table
global $wpdb;
$table_name = $wpdb->prefix . 'arewa_apk_comments';
$wpdb->query("DROP TABLE IF EXISTS {$table_name}");

// Delete all app posts
$apps = get_posts(array(
    'post_type' => 'arewa_apk_app',
    'posts_per_page' => -1,
    'post_status' => 'any'
));

foreach ($apps as $app) {
    wp_delete_post($app->ID, true);
}

// Delete all categories and tags
$categories = get_terms(array(
    'taxonomy' => 'arewa_apk_category',
    'hide_empty' => false,
));

if (!is_wp_error($categories) && !empty($categories)) {
    foreach ($categories as $category) {
        wp_delete_term($category->term_id, 'arewa_apk_category');
    }
}

$tags = get_terms(array(
    'taxonomy' => 'arewa_apk_tag',
    'hide_empty' => false,
));

if (!is_wp_error($tags) && !empty($tags)) {
    foreach ($tags as $tag) {
        wp_delete_term($tag->term_id, 'arewa_apk_tag');
    }
}
*/
