<?php
/**
 * Plugin Name: Arewa Mobile Bottom Navigation Bar
 * Plugin URI: https://arewa.dev/arewa-mobile-bottom-navigation-bar/
 * Description: A fully responsive, mobile-first floating bottom navigation bar with customizable buttons, submenus, and advanced visibility controls.
 * Version: 1.3.3
 * Author: A-Said
 * Author URI: https://arewa.dev/
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: arewa-mobile-bottom-navigation-bar
 * Domain Path: /languages
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'AREWA_MBN_VERSION', '1.3.3' );
define( 'AREWA_MBN_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'AREWA_MBN_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'AREWA_MBN_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
/** Maximum items to load in admin visibility lists (pages, posts, categories). Kept at 100 for coding standards; filter available for larger lists. */
define( 'AREWA_MBN_VISIBILITY_LIST_LIMIT', 100 );

// Load the main plugin class.
require_once AREWA_MBN_PLUGIN_DIR . 'includes/class-arewa-mobile-bottom-navigation.php';

// Initialize the plugin after WordPress is loaded.
add_action( 'plugins_loaded', array( 'Arewa_Mobile_Bottom_Navigation', 'get_instance' ) );
