<?php
/**
 * Button Manager
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Button Manager Class
 */
class Arewa_MBN_Button_Manager {

	/**
	 * Get all buttons
	 */
	public static function get_buttons() {
		$buttons = get_option( 'arewa_mbn_buttons', array() );

		// Sort by order.
		usort(
			$buttons,
			function( $a, $b ) {
				return $a['order'] - $b['order'];
			}
		);

		return $buttons;
	}

	/**
	 * Get button by ID
	 *
	 * @param string $button_id The button ID.
	 * @return array|null The button array or null if not found.
	 */
	public static function get_button( $button_id ) {
		$buttons = self::get_buttons();

		foreach ( $buttons as $button ) {
			if ( $button['id'] === $button_id ) {
				return $button;
			}
		}

		return null;
	}

	/**
	 * Update button order
	 *
	 * @param array $button_orders Array of button IDs and their order values.
	 * @return void
	 */
	public static function update_order( $button_orders ) {
		$buttons = get_option( 'arewa_mbn_buttons', array() );

		foreach ( $buttons as $key => $button ) {
			if ( isset( $button_orders[ $button['id'] ] ) ) {
				$buttons[ $key ]['order'] = absint( $button_orders[ $button['id'] ] );
			}
		}

		update_option( 'arewa_mbn_buttons', $buttons );
	}
}
