<?php
/**
 * Submenu Manager
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Submenu Manager Class
 */
class Arewa_MBN_Submenu_Manager {

	/**
	 * Get submenu for a button
	 *
	 * @param string $button_id The button ID.
	 * @return array The submenu items array.
	 */
	public static function get_submenu( $button_id ) {
		$submenus = get_option( 'arewa_mbn_submenus', array() );

		if ( isset( $submenus[ $button_id ] ) ) {
			return $submenus[ $button_id ];
		}

		return array();
	}

	/**
	 * Get all submenus
	 */
	public static function get_all_submenus() {
		return get_option( 'arewa_mbn_submenus', array() );
	}

	/**
	 * Check if button has submenu
	 *
	 * @param string $button_id The button ID.
	 * @return bool True if button has submenu, false otherwise.
	 */
	public static function has_submenu( $button_id ) {
		$submenu = self::get_submenu( $button_id );
		return ! empty( $submenu );
	}
}
