<?php
/**
 * Admin Buttons Configuration Template
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$arewa_mbn_button_count = isset( $settings['button_count'] ) ? intval( $settings['button_count'] ) : 4;
$arewa_mbn_buttons      = array_slice( $buttons, 0, $arewa_mbn_button_count );

// Normalize existing buttons - ensure has_submenu is '0' unless explicitly '1'.
foreach ( $arewa_mbn_buttons as $arewa_mbn_key => $arewa_mbn_button ) {
	if ( ! isset( $arewa_mbn_button['has_submenu'] ) || '1' !== $arewa_mbn_button['has_submenu'] ) {
		$arewa_mbn_buttons[ $arewa_mbn_key ]['has_submenu'] = '0';
	}
}

// Ensure we have enough buttons.
$arewa_mbn_buttons_count = count( $arewa_mbn_buttons );
while ( $arewa_mbn_buttons_count < $arewa_mbn_button_count ) {
	$arewa_mbn_buttons[] = array(
		'id'           => 'btn_' . ( $arewa_mbn_buttons_count + 1 ),
		'label'        => '',
		'icon'         => '',
		'icon_color'   => '#333333',
		'text_color'   => '#333333',
		'bg_color'     => 'transparent',
		'active_color' => '#0073aa',
		'url'          => '',
		'target'       => '_self',
		'has_submenu'  => '0',
		'order'        => $arewa_mbn_buttons_count + 1,
	);
	++$arewa_mbn_buttons_count;
}

// Sort by order.
usort(
	$arewa_mbn_buttons,
	function( $a, $b ) {
		return ( $a['order'] ?? 0 ) - ( $b['order'] ?? 0 );
	}
);
?>

<div class="arewa-mbn-tab-panel">
	<?php settings_errors( 'arewa_mbn_settings' ); ?>

	<form method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=arewa-mobile-bottom-navigation-bar&tab=buttons' ) ); ?>" id="arewa-mbn-buttons-form">
		<?php settings_fields( 'arewa_mbn_settings_group' ); ?>

		<div id="arewa-mbn-buttons-container">
			<?php foreach ( $arewa_mbn_buttons as $arewa_mbn_index => $arewa_mbn_button ) : ?>
				<?php $arewa_mbn_button_id = isset( $arewa_mbn_button['id'] ) ? $arewa_mbn_button['id'] : 'btn_' . ( $arewa_mbn_index + 1 ); ?>
				<div class="arewa-mbn-button-item" data-button-id="<?php echo esc_attr( $arewa_mbn_button_id ); ?>">
					<div class="button-handle">
						<span class="dashicons dashicons-menu"></span>
						<?php esc_html_e( 'Button', 'arewa-mobile-bottom-navigation-bar' ); ?> <?php echo esc_html( $arewa_mbn_index + 1 ); ?>
					</div>
					<div class="button-content">
						<input type="hidden" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][id]" value="<?php echo esc_attr( $arewa_mbn_button_id ); ?>">
						<input type="hidden" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][order]" value="<?php echo esc_attr( $arewa_mbn_button['order'] ?? $arewa_mbn_index + 1 ); ?>" class="button-order">

						<table class="form-table">
							<tr>
								<th><label><?php esc_html_e( 'Label', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<input type="text" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][label]" value="<?php echo esc_attr( $arewa_mbn_button['label'] ?? '' ); ?>" class="regular-text">
								</td>
							</tr>
							<tr>
								<th><label><?php esc_html_e( 'SVG Icon Code', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<textarea name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][icon]" rows="5" class="large-text code" placeholder='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg>'><?php echo isset( $arewa_mbn_button['icon'] ) ? esc_textarea( $arewa_mbn_button['icon'] ) : ''; ?></textarea>
									<p class="description">
										<?php esc_html_e( 'Paste your SVG code here. Example:', 'arewa-mobile-bottom-navigation-bar' ); ?>
										<code>&lt;svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"&gt;&lt;path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/&gt;&lt;/svg&gt;</code>
									</p>
								</td>
							</tr>
							<tr>
								<th><label><?php esc_html_e( 'Icon Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<?php
									$arewa_mbn_icon_color = isset( $arewa_mbn_button['icon_color'] ) ? $arewa_mbn_button['icon_color'] : '#333333';
									$arewa_mbn_icon_color = ( '' === trim( (string) $arewa_mbn_icon_color ) || ! is_string( $arewa_mbn_icon_color ) ) ? '#333333' : $arewa_mbn_icon_color;
									$arewa_mbn_icon_color = ( 4 === strlen( $arewa_mbn_icon_color ) ) ? '#' . $arewa_mbn_icon_color[1] . $arewa_mbn_icon_color[1] . $arewa_mbn_icon_color[2] . $arewa_mbn_icon_color[2] . $arewa_mbn_icon_color[3] . $arewa_mbn_icon_color[3] : $arewa_mbn_icon_color;
									?>
									<input type="color" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][icon_color]" value="<?php echo esc_attr( $arewa_mbn_icon_color ); ?>" class="arewa-mbn-native-color" aria-label="<?php esc_attr_e( 'Icon Color', 'arewa-mobile-bottom-navigation-bar' ); ?>">
									<p class="description"><?php esc_html_e( 'This color will be applied to the SVG fill or stroke. Make sure your SVG uses currentColor for this to work.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
								</td>
							</tr>
							<tr>
								<th><label><?php esc_html_e( 'Text Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<?php
									$arewa_mbn_text_color = isset( $arewa_mbn_button['text_color'] ) ? $arewa_mbn_button['text_color'] : '#333333';
									$arewa_mbn_text_color = ( '' === trim( (string) $arewa_mbn_text_color ) || ! is_string( $arewa_mbn_text_color ) ) ? '#333333' : $arewa_mbn_text_color;
									$arewa_mbn_text_color = ( 4 === strlen( $arewa_mbn_text_color ) ) ? '#' . $arewa_mbn_text_color[1] . $arewa_mbn_text_color[1] . $arewa_mbn_text_color[2] . $arewa_mbn_text_color[2] . $arewa_mbn_text_color[3] . $arewa_mbn_text_color[3] : $arewa_mbn_text_color;
									?>
									<input type="color" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][text_color]" value="<?php echo esc_attr( $arewa_mbn_text_color ); ?>" class="arewa-mbn-native-color" aria-label="<?php esc_attr_e( 'Text Color', 'arewa-mobile-bottom-navigation-bar' ); ?>">
									<p class="description"><?php esc_html_e( 'Color for the button label text.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
								</td>
							</tr>
							<tr>
								<th><label><?php esc_html_e( 'Background Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<?php
									$arewa_mbn_bg_val     = $arewa_mbn_button['bg_color'] ?? 'transparent';
									$arewa_mbn_bg_val     = ( 'transparent' === $arewa_mbn_bg_val || '' === trim( (string) $arewa_mbn_bg_val ) ) ? '' : $arewa_mbn_bg_val;
									$arewa_mbn_bg_display = ( '' !== $arewa_mbn_bg_val && 7 === strlen( $arewa_mbn_bg_val ) ) ? $arewa_mbn_bg_val : '#ffffff';
									if ( '' !== $arewa_mbn_bg_val && 4 === strlen( $arewa_mbn_bg_val ) ) {
										$arewa_mbn_bg_display = '#' . $arewa_mbn_bg_val[1] . $arewa_mbn_bg_val[1] . $arewa_mbn_bg_val[2] . $arewa_mbn_bg_val[2] . $arewa_mbn_bg_val[3] . $arewa_mbn_bg_val[3];
									}
									?>
									<input type="text" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][bg_color]" value="<?php echo esc_attr( $arewa_mbn_bg_val ); ?>" class="arewa-mbn-bg-color-value" id="arewa-mbn-bg-<?php echo esc_attr( $arewa_mbn_index ); ?>" data-button-index="<?php echo esc_attr( $arewa_mbn_index ); ?>">
									<input type="color" class="arewa-mbn-bg-color-picker" value="<?php echo esc_attr( $arewa_mbn_bg_display ); ?>" data-target="#arewa-mbn-bg-<?php echo esc_attr( $arewa_mbn_index ); ?>" aria-label="<?php esc_attr_e( 'Background Color', 'arewa-mobile-bottom-navigation-bar' ); ?>">
									<button type="button" class="button arewa-mbn-bg-transparent" data-target="#arewa-mbn-bg-<?php echo esc_attr( $arewa_mbn_index ); ?>"><?php esc_html_e( 'Transparent', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
								</td>
							</tr>
							<tr>
								<th><label><?php esc_html_e( 'Active State Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<?php
									$arewa_mbn_active_color = isset( $arewa_mbn_button['active_color'] ) ? $arewa_mbn_button['active_color'] : '#0073aa';
									$arewa_mbn_active_color = ( '' === trim( (string) $arewa_mbn_active_color ) || ! is_string( $arewa_mbn_active_color ) ) ? '#0073aa' : $arewa_mbn_active_color;
									$arewa_mbn_active_color = ( 4 === strlen( $arewa_mbn_active_color ) ) ? '#' . $arewa_mbn_active_color[1] . $arewa_mbn_active_color[1] . $arewa_mbn_active_color[2] . $arewa_mbn_active_color[2] . $arewa_mbn_active_color[3] . $arewa_mbn_active_color[3] : $arewa_mbn_active_color;
									?>
									<input type="color" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][active_color]" value="<?php echo esc_attr( $arewa_mbn_active_color ); ?>" class="arewa-mbn-native-color" aria-label="<?php esc_attr_e( 'Active State Color', 'arewa-mobile-bottom-navigation-bar' ); ?>">
								</td>
							</tr>
							<tr class="url-row">
								<th><label><?php esc_html_e( 'URL', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<input type="url" name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][url]" value="<?php echo esc_url( $arewa_mbn_button['url'] ?? '' ); ?>" class="regular-text">
									<p class="description"><?php esc_html_e( 'URL is not needed when submenu is enabled', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
								</td>
							</tr>
							<tr class="target-row">
								<th><label><?php esc_html_e( 'Link Target', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<select name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][target]">
										<option value="_self" <?php selected( $arewa_mbn_button['target'] ?? '_self', '_self' ); ?>><?php esc_html_e( 'Same Tab', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
										<option value="_blank" <?php selected( $arewa_mbn_button['target'] ?? '_self', '_blank' ); ?>><?php esc_html_e( 'New Tab', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
									</select>
								</td>
							</tr>
							<tr>
								<th><label><?php esc_html_e( 'Has Submenu', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
								<td>
									<?php
									// Ensure has_submenu is '0' by default, only '1' if explicitly set.
									$arewa_mbn_has_submenu        = ( isset( $arewa_mbn_button['has_submenu'] ) && '1' === $arewa_mbn_button['has_submenu'] ) ? '1' : '0';
									$arewa_mbn_has_submenu_select = ( '1' === $arewa_mbn_has_submenu ) ? 'enable' : 'disable';
									?>
									<select name="arewa_mbn_buttons[<?php echo esc_attr( $arewa_mbn_index ); ?>][has_submenu]" class="has-submenu-select arewa-mbn-enable-disable-select" data-button-index="<?php echo esc_attr( $arewa_mbn_index ); ?>">
										<option value="disable" <?php selected( $arewa_mbn_has_submenu_select, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
										<option value="enable" <?php selected( $arewa_mbn_has_submenu_select, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
									</select>
									<p class="description"><?php esc_html_e( 'Enable or disable submenu for this button. When enabled, this button will open a submenu instead of navigating to a URL.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
								</td>
							</tr>
						</table>
					</div>
				</div>
			<?php endforeach; ?>
		</div>

		<p class="submit">
			<input type="submit" name="arewa_mbn_save_buttons" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'arewa-mobile-bottom-navigation-bar' ); ?>">
		</p>
	</form>
</div>
