<?php
/**
 * Admin General Settings Template
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="arewa-mbn-tab-panel">
	<?php settings_errors( 'arewa_mbn_settings' ); ?>

	<form method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=arewa-mobile-bottom-navigation-bar&tab=general' ) ); ?>" id="arewa-mbn-general-form">
		<?php settings_fields( 'arewa_mbn_settings_group' ); ?>

		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="arewa_mbn_enabled"><?php esc_html_e( 'Enable Plugin', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					// Default to enabled ('1') if not set.
					$arewa_mbn_enabled_value  = isset( $settings['enabled'] ) ? $settings['enabled'] : '1';
					$arewa_mbn_enabled_select = ( '1' === $arewa_mbn_enabled_value ) ? 'enable' : 'disable';
					?>
					<select name="arewa_mbn_settings[enabled]" id="arewa_mbn_enabled" class="arewa-mbn-enable-disable-select">
						<option value="enable" <?php selected( $arewa_mbn_enabled_select, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="disable" <?php selected( $arewa_mbn_enabled_select, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable or disable the mobile bottom navigation plugin.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_button_count"><?php esc_html_e( 'Number of Buttons', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<select name="arewa_mbn_settings[button_count]" id="arewa_mbn_button_count">
						<?php for ( $arewa_mbn_i = 2; $arewa_mbn_i <= 6; $arewa_mbn_i++ ) : ?>
							<option value="<?php echo esc_attr( $arewa_mbn_i ); ?>" <?php selected( isset( $settings['button_count'] ) ? $settings['button_count'] : 4, $arewa_mbn_i ); ?>>
								<?php echo esc_html( $arewa_mbn_i ); ?>
							</option>
						<?php endfor; ?>
					</select>
					<p class="description"><?php esc_html_e( 'Select the number of buttons to display (2-6).', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_layout_style"><?php esc_html_e( 'Layout Style', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<select name="arewa_mbn_settings[layout_style]" id="arewa_mbn_layout_style">
						<option value="icon_only" <?php selected( isset( $settings['layout_style'] ) ? $settings['layout_style'] : 'icon_text', 'icon_only' ); ?>>
							<?php esc_html_e( 'Icon Only', 'arewa-mobile-bottom-navigation-bar' ); ?>
						</option>
						<option value="icon_text" <?php selected( isset( $settings['layout_style'] ) ? $settings['layout_style'] : 'icon_text', 'icon_text' ); ?>>
							<?php esc_html_e( 'Icon + Text', 'arewa-mobile-bottom-navigation-bar' ); ?>
						</option>
						<option value="icon_text_active" <?php selected( isset( $settings['layout_style'] ) ? $settings['layout_style'] : 'icon_text', 'icon_text_active' ); ?>>
							<?php esc_html_e( 'Icon + Text on Active Button', 'arewa-mobile-bottom-navigation-bar' ); ?>
						</option>
					</select>
					<p class="description"><?php esc_html_e( '"Icon + Text on Active Button" shows text only on the active/selected button, similar to webview navigation.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
		</table>

		<p class="submit">
			<input type="submit" name="arewa_mbn_save_general" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'arewa-mobile-bottom-navigation-bar' ); ?>">
		</p>
	</form>
</div>
