<?php
/**
 * Admin Settings Template with Horizontal Tabs
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$arewa_mbn_admin_url = admin_url( 'admin.php?page=arewa-mobile-bottom-navigation-bar' );
?>

<div class="wrap arewa-mbn-admin">
	<h1><?php esc_html_e( 'Mobile Bottom Navigation', 'arewa-mobile-bottom-navigation-bar' ); ?></h1>

	<?php settings_errors( 'arewa_mbn_settings' ); ?>

	<nav class="nav-tab-wrapper arewa-mbn-tabs-wrapper">
		<?php foreach ( $tabs as $arewa_mbn_tab_key => $arewa_mbn_tab_label ) : ?>
			<?php
			$arewa_mbn_tab_url = add_query_arg(
				array(
					'tab'      => $arewa_mbn_tab_key,
					'_wpnonce' => wp_create_nonce( 'arewa_mbn_tab' ),
				),
				$arewa_mbn_admin_url
			);
			?>
			<a href="<?php echo esc_url( $arewa_mbn_tab_url ); ?>"
			class="nav-tab <?php echo ( $current_tab === $arewa_mbn_tab_key ) ? 'nav-tab-active' : ''; ?>">
				<?php echo esc_html( $arewa_mbn_tab_label ); ?>
			</a>
		<?php endforeach; ?>
		<a href="https://arewa.dev/arewa-mobile-bottom-navigation-bar/"
		target="_blank"
		rel="noopener noreferrer"
		class="nav-tab arewa-mbn-docs-button"
		title="<?php esc_attr_e( 'View Documentation', 'arewa-mobile-bottom-navigation-bar' ); ?>">
			<span class="dashicons dashicons-book-alt"></span>
			<?php esc_html_e( 'Documentation', 'arewa-mobile-bottom-navigation-bar' ); ?>
		</a>
	</nav>

	<div class="arewa-mbn-tab-content">
		<?php
		switch ( $current_tab ) {
			case 'general':
				include AREWA_MBN_PLUGIN_DIR . 'templates/admin-general.php';
				break;
			case 'buttons':
				include AREWA_MBN_PLUGIN_DIR . 'templates/admin-buttons.php';
				break;
			case 'submenus':
				include AREWA_MBN_PLUGIN_DIR . 'templates/admin-submenus.php';
				break;
			case 'styling':
				include AREWA_MBN_PLUGIN_DIR . 'templates/admin-styling.php';
				break;
			case 'visibility':
				include AREWA_MBN_PLUGIN_DIR . 'templates/admin-visibility.php';
				break;
			default:
				include AREWA_MBN_PLUGIN_DIR . 'templates/admin-general.php';
				break;
		}
		?>
	</div>
</div>
