<?php
/**
 * Admin Styling & Appearance Template
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="arewa-mbn-tab-panel">
	<?php settings_errors( 'arewa_mbn_settings' ); ?>

	<form method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=arewa-mobile-bottom-navigation-bar&tab=styling' ) ); ?>" id="arewa-mbn-styling-form">
		<?php settings_fields( 'arewa_mbn_settings_group' ); ?>

		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="arewa_mbn_background_color"><?php esc_html_e( 'Background Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[background_color]" id="arewa_mbn_background_color" value="<?php echo esc_attr( $settings['background_color'] ?? '#ffffff' ); ?>" class="color-picker">
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_border_radius"><?php esc_html_e( 'Border Radius (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[border_radius]" id="arewa_mbn_border_radius" value="<?php echo esc_attr( $settings['border_radius'] ?? 0 ); ?>" min="0" max="50" class="small-text">
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_box_shadow"><?php esc_html_e( 'Box Shadow', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_box_shadow_value = ( isset( $settings['box_shadow'] ) && '1' === $settings['box_shadow'] ) ? 'enable' : ( isset( $settings['box_shadow'] ) ? 'disable' : 'enable' );
					?>
					<select name="arewa_mbn_settings[box_shadow]" id="arewa_mbn_box_shadow" class="arewa-mbn-enable-disable-select">
						<option value="enable" <?php selected( $arewa_mbn_box_shadow_value, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="disable" <?php selected( $arewa_mbn_box_shadow_value, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable or disable box shadow for the navigation bar.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_active_color"><?php esc_html_e( 'Active Button Highlight Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[active_color]" id="arewa_mbn_active_color" value="<?php echo esc_attr( $settings['active_color'] ?? '#0073aa' ); ?>" class="color-picker">
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_hover_effect"><?php esc_html_e( 'Hover Effects', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_hover_effect_value = ( isset( $settings['hover_effect'] ) && '1' === $settings['hover_effect'] ) ? 'enable' : ( isset( $settings['hover_effect'] ) ? 'disable' : 'enable' );
					?>
					<select name="arewa_mbn_settings[hover_effect]" id="arewa_mbn_hover_effect" class="arewa-mbn-enable-disable-select">
						<option value="enable" <?php selected( $arewa_mbn_hover_effect_value, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="disable" <?php selected( $arewa_mbn_hover_effect_value, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable or disable hover effects on navigation buttons.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_pulse_animation"><?php esc_html_e( 'Active Button Pulse Animation', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_pulse_animation_value  = isset( $settings['pulse_animation'] ) ? $settings['pulse_animation'] : '1';
					$arewa_mbn_pulse_animation_select = ( '1' === $arewa_mbn_pulse_animation_value ) ? 'enable' : 'disable';
					?>
					<select name="arewa_mbn_settings[pulse_animation]" id="arewa_mbn_pulse_animation" class="arewa-mbn-enable-disable-select">
						<option value="enable" <?php selected( $arewa_mbn_pulse_animation_select, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="disable" <?php selected( $arewa_mbn_pulse_animation_select, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable or disable pulse animation on active button icon. Shows a pulsing circular background animation around the active button icon.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
		</table>

		<h2><?php esc_html_e( 'Button Styling', 'arewa-mobile-bottom-navigation-bar' ); ?></h2>
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="arewa_mbn_button_text_size"><?php esc_html_e( 'Button Text Size (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[button_text_size]" id="arewa_mbn_button_text_size" value="<?php echo esc_attr( $settings['button_text_size'] ?? 12 ); ?>" min="8" max="20" class="small-text">
					<p class="description"><?php esc_html_e( 'Font size for button labels (8-20px)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_button_icon_size"><?php esc_html_e( 'Button Icon Size (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[button_icon_size]" id="arewa_mbn_button_icon_size" value="<?php echo esc_attr( $settings['button_icon_size'] ?? 20 ); ?>" min="12" max="32" class="small-text">
					<p class="description"><?php esc_html_e( 'Size for button icons (12-32px)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
		</table>

		<h2><?php esc_html_e( 'Submenu Header', 'arewa-mobile-bottom-navigation-bar' ); ?></h2>
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_header_enable"><?php esc_html_e( 'Enable Submenu Header', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_submenu_header_enable_value = ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? 'enable' : ( isset( $settings['submenu_header_enable'] ) ? 'disable' : 'enable' );
					?>
					<select name="arewa_mbn_settings[submenu_header_enable]" id="arewa_mbn_submenu_header_enable" class="arewa-mbn-enable-disable-select">
						<option value="enable" <?php selected( $arewa_mbn_submenu_header_enable_value, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="disable" <?php selected( $arewa_mbn_submenu_header_enable_value, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable or disable the header with logo and site title in submenu.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_logo"><?php esc_html_e( 'Site Logo', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_logo_url = isset( $settings['submenu_header_logo'] ) ? esc_url( $settings['submenu_header_logo'] ) : '';
					$arewa_mbn_logo_id  = isset( $settings['submenu_header_logo_id'] ) ? intval( $settings['submenu_header_logo_id'] ) : 0;
					?>
					<div class="submenu-logo-preview" style="margin-bottom: 10px;">
						<?php if ( $arewa_mbn_logo_url ) : ?>
							<img src="<?php echo esc_url( $arewa_mbn_logo_url ); ?>" alt="Logo Preview" style="max-width: 150px; max-height: 60px; display: block; margin-bottom: 10px;">
						<?php endif; ?>
					</div>
					<input type="hidden" name="arewa_mbn_settings[submenu_header_logo_id]" id="arewa_mbn_submenu_header_logo_id" value="<?php echo esc_attr( $arewa_mbn_logo_id ); ?>">
					<input type="text" name="arewa_mbn_settings[submenu_header_logo]" id="arewa_mbn_submenu_header_logo" value="<?php echo esc_attr( $arewa_mbn_logo_url ); ?>" class="regular-text" placeholder="<?php esc_attr_e( 'Logo URL or click button to upload', 'arewa-mobile-bottom-navigation-bar' ); ?>">
					<button type="button" class="button arewa-mbn-upload-logo" data-target="arewa_mbn_submenu_header_logo" data-id-target="arewa_mbn_submenu_header_logo_id"><?php esc_html_e( 'Upload Logo', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
					<button type="button" class="button arewa-mbn-remove-logo" data-target="arewa_mbn_submenu_header_logo" data-id-target="arewa_mbn_submenu_header_logo_id" style="<?php echo $arewa_mbn_logo_url ? '' : 'display:none;'; ?>"><?php esc_html_e( 'Remove Logo', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
					<p class="description"><?php esc_html_e( 'Upload or enter URL of your site logo. Recommended size: 120x120px for circular logo.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_logo_size"><?php esc_html_e( 'Logo Size (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_header_logo_size]" id="arewa_mbn_submenu_header_logo_size" value="<?php echo esc_attr( $settings['submenu_header_logo_size'] ?? 120 ); ?>" min="60" max="200" class="small-text">
					<p class="description"><?php esc_html_e( 'Size of the circular logo in pixels (60-200px). Recommended: 120px.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_title"><?php esc_html_e( 'Site Title', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[submenu_header_title]" id="arewa_mbn_submenu_header_title" value="<?php echo esc_attr( $settings['submenu_header_title'] ?? get_bloginfo( 'name' ) ); ?>" class="regular-text">
					<p class="description"><?php esc_html_e( 'Title to display in submenu header. Default: Site name from WordPress settings.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_description"><?php esc_html_e( 'Description', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<textarea name="arewa_mbn_settings[submenu_header_description]" id="arewa_mbn_submenu_header_description" rows="3" class="large-text" maxlength="150" placeholder="<?php esc_attr_e( 'Enter a short description (max 150 characters)', 'arewa-mobile-bottom-navigation-bar' ); ?>"><?php echo esc_textarea( $settings['submenu_header_description'] ?? '' ); ?></textarea>
					<p class="description">
						<?php esc_html_e( 'Short description to display below the title. Maximum 150 characters.', 'arewa-mobile-bottom-navigation-bar' ); ?>
						<span id="arewa_mbn_description_counter"><?php echo esc_html( strlen( $settings['submenu_header_description'] ?? '' ) ); ?>/150</span>
					</p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_bg_color"><?php esc_html_e( 'Header Background Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[submenu_header_bg_color]" id="arewa_mbn_submenu_header_bg_color" value="<?php echo esc_attr( $settings['submenu_header_bg_color'] ?? 'transparent' ); ?>" class="color-picker">
					<p class="description"><?php esc_html_e( 'Background color for the submenu header', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_title_color"><?php esc_html_e( 'Site Title Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[submenu_header_title_color]" id="arewa_mbn_submenu_header_title_color" value="<?php echo esc_attr( $settings['submenu_header_title_color'] ?? '#ffffff' ); ?>" class="color-picker">
					<p class="description"><?php esc_html_e( 'Color for the site title in the header', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_title_size"><?php esc_html_e( 'Site Title Size (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_header_title_size]" id="arewa_mbn_submenu_header_title_size" value="<?php echo esc_attr( $settings['submenu_header_title_size'] ?? 18 ); ?>" min="12" max="32" class="small-text">
					<p class="description"><?php esc_html_e( 'Font size for the site title (12-32px)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_description_color"><?php esc_html_e( 'Description Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[submenu_header_description_color]" id="arewa_mbn_submenu_header_description_color" value="<?php echo esc_attr( $settings['submenu_header_description_color'] ?? 'rgba(255, 255, 255, 0.7)' ); ?>" class="color-picker">
					<p class="description"><?php esc_html_e( 'Color for the description text in the header', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="submenu-header-options" style="<?php echo ( isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'] ) ? '' : 'display:none;'; ?>" data-dependency="arewa_mbn_submenu_header_enable">
				<th scope="row">
					<label for="arewa_mbn_submenu_header_description_size"><?php esc_html_e( 'Description Size (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_header_description_size]" id="arewa_mbn_submenu_header_description_size" value="<?php echo esc_attr( $settings['submenu_header_description_size'] ?? 13 ); ?>" min="10" max="20" class="small-text">
					<p class="description"><?php esc_html_e( 'Font size for the description text (10-20px)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
		</table>

		<h2><?php esc_html_e( 'Submenu Styling', 'arewa-mobile-bottom-navigation-bar' ); ?></h2>
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_bg_color"><?php esc_html_e( 'Submenu Background Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[submenu_bg_color]" id="arewa_mbn_submenu_bg_color" value="<?php echo esc_attr( $settings['submenu_bg_color'] ?? '#1e1e28' ); ?>" class="color-picker">
					<p class="description"><?php esc_html_e( 'Background color for the submenu overlay', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_bg_opacity"><?php esc_html_e( 'Submenu Background Opacity', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_bg_opacity]" id="arewa_mbn_submenu_bg_opacity" value="<?php echo esc_attr( $settings['submenu_bg_opacity'] ?? 95 ); ?>" min="0" max="100" class="small-text" step="1">
					<span>%</span>
					<p class="description"><?php esc_html_e( 'Opacity of the submenu background (0-100)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_shadow"><?php esc_html_e( 'Submenu Shadow', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_submenu_shadow_value = ( isset( $settings['submenu_shadow'] ) && '1' === $settings['submenu_shadow'] ) ? 'enable' : ( isset( $settings['submenu_shadow'] ) ? 'disable' : 'enable' );
					?>
					<select name="arewa_mbn_settings[submenu_shadow]" id="arewa_mbn_submenu_shadow" class="arewa-mbn-enable-disable-select">
						<option value="enable" <?php selected( $arewa_mbn_submenu_shadow_value, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="disable" <?php selected( $arewa_mbn_submenu_shadow_value, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable or disable shadow for the submenu.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_width"><?php esc_html_e( 'Submenu Width (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_width]" id="arewa_mbn_submenu_width" value="<?php echo esc_attr( $settings['submenu_width'] ?? 320 ); ?>" min="200" max="600" class="small-text">
					<p class="description"><?php esc_html_e( 'Minimum width of the submenu in pixels', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_text_color"><?php esc_html_e( 'Submenu Text Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[submenu_text_color]" id="arewa_mbn_submenu_text_color" value="<?php echo esc_attr( $settings['submenu_text_color'] ?? '#ffffff' ); ?>" class="color-picker">
					<p class="description"><?php esc_html_e( 'Text color for submenu items', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_icon_spacing"><?php esc_html_e( 'Icon Spacing (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_icon_spacing]" id="arewa_mbn_submenu_icon_spacing" value="<?php echo esc_attr( $settings['submenu_icon_spacing'] ?? 8 ); ?>" min="0" max="30" class="small-text">
					<p class="description"><?php esc_html_e( 'Space between icon and text in submenu items (0-30px)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_shadow_color"><?php esc_html_e( 'Submenu Shadow Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="text" name="arewa_mbn_settings[submenu_shadow_color]" id="arewa_mbn_submenu_shadow_color" value="<?php echo esc_attr( $settings['submenu_shadow_color'] ?? '#000000' ); ?>" class="color-picker">
					<p class="description"><?php esc_html_e( 'Color of the submenu shadow', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_text_size"><?php esc_html_e( 'Submenu Text Size (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_text_size]" id="arewa_mbn_submenu_text_size" value="<?php echo esc_attr( $settings['submenu_text_size'] ?? 14 ); ?>" min="10" max="20" class="small-text">
					<p class="description"><?php esc_html_e( 'Font size for submenu item labels (10-20px)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_submenu_icon_size"><?php esc_html_e( 'Submenu Icon Size (px)', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<input type="number" name="arewa_mbn_settings[submenu_icon_size]" id="arewa_mbn_submenu_icon_size" value="<?php echo esc_attr( $settings['submenu_icon_size'] ?? 22 ); ?>" min="16" max="32" class="small-text">
					<p class="description"><?php esc_html_e( 'Size for submenu item icons (16-32px)', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
		</table>

		<p class="submit">
			<input type="submit" name="arewa_mbn_save_styling" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'arewa-mobile-bottom-navigation-bar' ); ?>">
		</p>
	</form>
</div>
