<?php
/**
 * Admin Submenu Configuration Template
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$arewa_mbn_button_count = isset( $settings['button_count'] ) ? intval( $settings['button_count'] ) : 4;
$arewa_mbn_buttons      = array_slice( $buttons, 0, $arewa_mbn_button_count );

// Sort by order.
usort(
	$arewa_mbn_buttons,
	function( $a, $b ) {
		return ( $a['order'] ?? 0 ) - ( $b['order'] ?? 0 );
	}
);
?>

<div class="arewa-mbn-tab-panel">
	<?php settings_errors( 'arewa_mbn_settings' ); ?>

	<p><?php esc_html_e( 'Configure submenus for buttons that have submenu enabled. Click on a button below to manage its submenu items.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>

	<form method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=arewa-mobile-bottom-navigation-bar&tab=submenus' ) ); ?>" id="arewa-mbn-submenus-form">
		<?php settings_fields( 'arewa_mbn_settings_group' ); ?>

		<?php foreach ( $arewa_mbn_buttons as $arewa_mbn_index => $arewa_mbn_button ) : ?>
			<?php
			$arewa_mbn_button_id = $arewa_mbn_button['id'];
			if ( isset( $arewa_mbn_button['has_submenu'] ) && '1' === $arewa_mbn_button['has_submenu'] ) :
				$arewa_mbn_button_submenu = isset( $submenus[ $arewa_mbn_button_id ] ) ? $submenus[ $arewa_mbn_button_id ] : array();
				?>
				<div class="arewa-mbn-submenu-section" data-button-id="<?php echo esc_attr( $arewa_mbn_button_id ); ?>">
					<h3><?php echo esc_html( ( ! empty( $arewa_mbn_button['label'] ) ) ? $arewa_mbn_button['label'] : esc_html__( 'Button', 'arewa-mobile-bottom-navigation-bar' ) . ' ' . esc_html( $arewa_mbn_index + 1 ) ); ?></h3>
					<div class="submenu-items-container">
						<?php if ( ! empty( $arewa_mbn_button_submenu ) ) : ?>
							<?php foreach ( $arewa_mbn_button_submenu as $arewa_mbn_item_index => $arewa_mbn_item ) : ?>
								<div class="submenu-item">
									<table class="form-table">
										<tr>
											<th><label><?php esc_html_e( 'Label', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
											<td>
												<input type="text" name="arewa_mbn_submenus[<?php echo esc_attr( $arewa_mbn_button_id ); ?>][<?php echo esc_attr( $arewa_mbn_item_index ); ?>][label]" value="<?php echo esc_attr( $arewa_mbn_item['label'] ?? '' ); ?>" class="regular-text">
											</td>
										</tr>
										<tr>
											<th><label><?php esc_html_e( 'SVG Icon Code', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
											<td>
												<textarea name="arewa_mbn_submenus[<?php echo esc_attr( $arewa_mbn_button_id ); ?>][<?php echo esc_attr( $arewa_mbn_item_index ); ?>][icon]" rows="5" class="large-text code" placeholder='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg>'><?php echo isset( $arewa_mbn_item['icon'] ) ? esc_textarea( $arewa_mbn_item['icon'] ) : ''; ?></textarea>
												<p class="description"><?php esc_html_e( 'Paste your SVG code here.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
											</td>
										</tr>
										<tr>
											<th><label><?php esc_html_e( 'Icon Color', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
											<td>
												<input type="text" name="arewa_mbn_submenus[<?php echo esc_attr( $arewa_mbn_button_id ); ?>][<?php echo esc_attr( $arewa_mbn_item_index ); ?>][icon_color]" value="<?php echo esc_attr( $arewa_mbn_item['icon_color'] ?? '#333333' ); ?>" class="color-picker">
											</td>
										</tr>
										<tr>
											<th><label><?php esc_html_e( 'URL', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
											<td>
												<input type="url" name="arewa_mbn_submenus[<?php echo esc_attr( $arewa_mbn_button_id ); ?>][<?php echo esc_attr( $arewa_mbn_item_index ); ?>][url]" value="<?php echo esc_url( $arewa_mbn_item['url'] ?? '' ); ?>" class="regular-text">
											</td>
										</tr>
										<tr>
											<th><label><?php esc_html_e( 'Link Target', 'arewa-mobile-bottom-navigation-bar' ); ?></label></th>
											<td>
												<select name="arewa_mbn_submenus[<?php echo esc_attr( $arewa_mbn_button_id ); ?>][<?php echo esc_attr( $arewa_mbn_item_index ); ?>][target]">
													<option value="_self" <?php selected( $arewa_mbn_item['target'] ?? '_self', '_self' ); ?>><?php esc_html_e( 'Same Tab', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
													<option value="_blank" <?php selected( $arewa_mbn_item['target'] ?? '_self', '_blank' ); ?>><?php esc_html_e( 'New Tab', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
												</select>
											</td>
										</tr>
									</table>
									<button type="button" class="button remove-submenu-item"><?php esc_html_e( 'Remove Item', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
								</div>
							<?php endforeach; ?>
						<?php endif; ?>
						<button type="button" class="button add-submenu-item" data-button-id="<?php echo esc_attr( $arewa_mbn_button_id ); ?>"><?php esc_html_e( 'Add Submenu Item', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
					</div>
				</div>
			<?php endif; ?>
		<?php endforeach; ?>

		<p class="submit">
			<input type="submit" name="arewa_mbn_save_submenus" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'arewa-mobile-bottom-navigation-bar' ); ?>">
		</p>
	</form>
</div>
