<?php
/**
 * Admin Visibility Conditions Template
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get all pages, posts, categories, and post types for visibility settings.
$arewa_mbn_all_pages      = get_pages( array( 'number' => AREWA_MBN_VISIBILITY_LIST_LIMIT ) );
$arewa_mbn_all_posts      = get_posts(
	array(
		'numberposts' => 100,
		'post_type'   => 'post',
	)
);
$arewa_mbn_all_categories = get_categories( array( 'number' => AREWA_MBN_VISIBILITY_LIST_LIMIT ) );
$arewa_mbn_all_post_types = get_post_types( array( 'public' => true ), 'objects' );
?>

<div class="arewa-mbn-tab-panel">
	<?php settings_errors( 'arewa_mbn_settings' ); ?>

	<form method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=arewa-mobile-bottom-navigation-bar&tab=visibility' ) ); ?>" id="arewa-mbn-visibility-form">
		<?php settings_fields( 'arewa_mbn_settings_group' ); ?>

		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="arewa_mbn_visibility_mode"><?php esc_html_e( 'Display Mode', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					// Get current visibility modes (support both old single value and new array).
					$arewa_mbn_current_modes = isset( $settings['visibility_mode'] ) ? $settings['visibility_mode'] : 'all';
					if ( ! is_array( $arewa_mbn_current_modes ) ) {
						$arewa_mbn_current_modes = ( 'all' === $arewa_mbn_current_modes ) ? array() : array( $arewa_mbn_current_modes );
					}
					?>
					<div class="arewa-mbn-display-mode-container">
						<label class="arewa-mbn-checkbox-item">
							<input type="checkbox" name="arewa_mbn_settings[visibility_mode][]" value="all" id="arewa_mbn_visibility_mode_all" <?php checked( in_array( 'all', $arewa_mbn_current_modes, true ) || empty( $arewa_mbn_current_modes ) ); ?>>
							<span><?php esc_html_e( 'Entire Site', 'arewa-mobile-bottom-navigation-bar' ); ?></span>
						</label>
						<label class="arewa-mbn-checkbox-item">
							<input type="checkbox" name="arewa_mbn_settings[visibility_mode][]" value="homepage" id="arewa_mbn_visibility_mode_homepage" <?php checked( in_array( 'homepage', $arewa_mbn_current_modes, true ) ); ?>>
							<span><?php esc_html_e( 'Homepage Only', 'arewa-mobile-bottom-navigation-bar' ); ?></span>
						</label>
						<label class="arewa-mbn-checkbox-item">
							<input type="checkbox" name="arewa_mbn_settings[visibility_mode][]" value="pages" id="arewa_mbn_visibility_mode_pages" <?php checked( in_array( 'pages', $arewa_mbn_current_modes, true ) ); ?>>
							<span><?php esc_html_e( 'Specific Pages', 'arewa-mobile-bottom-navigation-bar' ); ?></span>
						</label>
						<label class="arewa-mbn-checkbox-item">
							<input type="checkbox" name="arewa_mbn_settings[visibility_mode][]" value="posts" id="arewa_mbn_visibility_mode_posts" <?php checked( in_array( 'posts', $arewa_mbn_current_modes, true ) ); ?>>
							<span><?php esc_html_e( 'Specific Posts', 'arewa-mobile-bottom-navigation-bar' ); ?></span>
						</label>
						<label class="arewa-mbn-checkbox-item">
							<input type="checkbox" name="arewa_mbn_settings[visibility_mode][]" value="categories" id="arewa_mbn_visibility_mode_categories" <?php checked( in_array( 'categories', $arewa_mbn_current_modes, true ) ); ?>>
							<span><?php esc_html_e( 'Categories', 'arewa-mobile-bottom-navigation-bar' ); ?></span>
						</label>
						<label class="arewa-mbn-checkbox-item">
							<input type="checkbox" name="arewa_mbn_settings[visibility_mode][]" value="post_types" id="arewa_mbn_visibility_mode_post_types" <?php checked( in_array( 'post_types', $arewa_mbn_current_modes, true ) ); ?>>
							<span><?php esc_html_e( 'Custom Post Types', 'arewa-mobile-bottom-navigation-bar' ); ?></span>
						</label>
					</div>
					<p class="description"><?php esc_html_e( 'Select one or more display modes. You can combine multiple options (e.g., Specific Pages AND Specific Posts).', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="visibility-pages-row" style="
			<?php
				$arewa_mbn_modes       = isset( $settings['visibility_mode'] ) ? $settings['visibility_mode'] : 'all';
				$arewa_mbn_modes_array = is_array( $arewa_mbn_modes ) ? $arewa_mbn_modes : ( ( 'all' === $arewa_mbn_modes ) ? array() : array( $arewa_mbn_modes ) );
				echo in_array( 'pages', $arewa_mbn_modes_array, true ) ? '' : 'display:none;';
			?>
			">
				<th scope="row">
					<label><?php esc_html_e( 'Select Pages', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<div class="arewa-mbn-multi-select-container">
						<div class="arewa-mbn-multi-select-header">
							<input type="text" class="arewa-mbn-search-input" placeholder="<?php esc_attr_e( 'Search pages...', 'arewa-mobile-bottom-navigation-bar' ); ?>" data-target="pages">
							<div class="arewa-mbn-select-actions">
								<button type="button" class="button button-small arewa-mbn-select-all" data-target="pages"><?php esc_html_e( 'Select All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
								<button type="button" class="button button-small arewa-mbn-deselect-all" data-target="pages"><?php esc_html_e( 'Deselect All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
							</div>
						</div>
						<div class="arewa-mbn-checkbox-container" data-type="pages">
							<?php foreach ( $arewa_mbn_all_pages as $arewa_mbn_page_item ) : ?>
								<label class="arewa-mbn-checkbox-item">
									<input type="checkbox" name="arewa_mbn_settings[visibility_pages][]" value="<?php echo esc_attr( $arewa_mbn_page_item->ID ); ?>" <?php checked( in_array( $arewa_mbn_page_item->ID, $settings['visibility_pages'] ?? array(), true ) ); ?>>
									<span><?php echo esc_html( $arewa_mbn_page_item->post_title ); ?></span>
								</label>
							<?php endforeach; ?>
						</div>
						<p class="description"><?php esc_html_e( 'Click to select or deselect pages. Use the search box to filter pages.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
					</div>
				</td>
			</tr>
			<tr class="visibility-posts-row" style="<?php echo ( 'posts' !== ( $settings['visibility_mode'] ?? 'all' ) ) ? 'display:none;' : ''; ?>">
				<th scope="row">
					<label><?php esc_html_e( 'Select Posts', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<div class="arewa-mbn-multi-select-container">
						<div class="arewa-mbn-multi-select-header">
							<input type="text" class="arewa-mbn-search-input" placeholder="<?php esc_attr_e( 'Search posts...', 'arewa-mobile-bottom-navigation-bar' ); ?>" data-target="posts">
							<div class="arewa-mbn-select-actions">
								<button type="button" class="button button-small arewa-mbn-select-all" data-target="posts"><?php esc_html_e( 'Select All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
								<button type="button" class="button button-small arewa-mbn-deselect-all" data-target="posts"><?php esc_html_e( 'Deselect All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
							</div>
						</div>
						<div class="arewa-mbn-checkbox-container" data-type="posts">
							<?php foreach ( $arewa_mbn_all_posts as $arewa_mbn_post_item ) : ?>
								<label class="arewa-mbn-checkbox-item">
									<input type="checkbox" name="arewa_mbn_settings[visibility_posts][]" value="<?php echo esc_attr( $arewa_mbn_post_item->ID ); ?>" <?php checked( in_array( $arewa_mbn_post_item->ID, $settings['visibility_posts'] ?? array(), true ) ); ?>>
									<span><?php echo esc_html( $arewa_mbn_post_item->post_title ); ?></span>
								</label>
							<?php endforeach; ?>
						</div>
						<p class="description"><?php esc_html_e( 'Click to select or deselect posts. Use the search box to filter posts.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
					</div>
				</td>
			</tr>
			<tr class="visibility-categories-row" style="
			<?php
				$arewa_mbn_modes       = isset( $settings['visibility_mode'] ) ? $settings['visibility_mode'] : 'all';
				$arewa_mbn_modes_array = is_array( $arewa_mbn_modes ) ? $arewa_mbn_modes : ( ( 'all' === $arewa_mbn_modes ) ? array() : array( $arewa_mbn_modes ) );
				echo in_array( 'categories', $arewa_mbn_modes_array, true ) ? '' : 'display:none;';
			?>
			">
				<th scope="row">
					<label><?php esc_html_e( 'Select Categories', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<div class="arewa-mbn-multi-select-container">
						<div class="arewa-mbn-multi-select-header">
							<input type="text" class="arewa-mbn-search-input" placeholder="<?php esc_attr_e( 'Search categories...', 'arewa-mobile-bottom-navigation-bar' ); ?>" data-target="categories">
							<div class="arewa-mbn-select-actions">
								<button type="button" class="button button-small arewa-mbn-select-all" data-target="categories"><?php esc_html_e( 'Select All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
								<button type="button" class="button button-small arewa-mbn-deselect-all" data-target="categories"><?php esc_html_e( 'Deselect All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
							</div>
						</div>
						<div class="arewa-mbn-checkbox-container" data-type="categories">
							<?php foreach ( $arewa_mbn_all_categories as $arewa_mbn_category_item ) : ?>
								<label class="arewa-mbn-checkbox-item">
									<input type="checkbox" name="arewa_mbn_settings[visibility_categories][]" value="<?php echo esc_attr( $arewa_mbn_category_item->term_id ); ?>" <?php checked( in_array( $arewa_mbn_category_item->term_id, $settings['visibility_categories'] ?? array(), true ) ); ?>>
									<span><?php echo esc_html( $arewa_mbn_category_item->name ); ?></span>
								</label>
							<?php endforeach; ?>
						</div>
						<p class="description"><?php esc_html_e( 'Click to select or deselect categories. Use the search box to filter categories.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
					</div>
				</td>
			</tr>
			<tr class="visibility-post-types-row" style="
			<?php
				$arewa_mbn_modes       = isset( $settings['visibility_mode'] ) ? $settings['visibility_mode'] : 'all';
				$arewa_mbn_modes_array = is_array( $arewa_mbn_modes ) ? $arewa_mbn_modes : ( ( 'all' === $arewa_mbn_modes ) ? array() : array( $arewa_mbn_modes ) );
				echo in_array( 'post_types', $arewa_mbn_modes_array, true ) ? '' : 'display:none;';
			?>
			">
				<th scope="row">
					<label><?php esc_html_e( 'Select Post Types', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<div class="arewa-mbn-multi-select-container">
						<div class="arewa-mbn-multi-select-header">
							<input type="text" class="arewa-mbn-search-input" placeholder="<?php esc_attr_e( 'Search post types...', 'arewa-mobile-bottom-navigation-bar' ); ?>" data-target="post_types">
							<div class="arewa-mbn-select-actions">
								<button type="button" class="button button-small arewa-mbn-select-all" data-target="post_types"><?php esc_html_e( 'Select All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
								<button type="button" class="button button-small arewa-mbn-deselect-all" data-target="post_types"><?php esc_html_e( 'Deselect All', 'arewa-mobile-bottom-navigation-bar' ); ?></button>
							</div>
						</div>
						<div class="arewa-mbn-checkbox-container" data-type="post_types">
							<?php foreach ( $arewa_mbn_all_post_types as $arewa_mbn_post_type_item ) : ?>
								<label class="arewa-mbn-checkbox-item">
									<input type="checkbox" name="arewa_mbn_settings[visibility_post_types][]" value="<?php echo esc_attr( $arewa_mbn_post_type_item->name ); ?>" <?php checked( in_array( $arewa_mbn_post_type_item->name, $settings['visibility_post_types'] ?? array(), true ) ); ?>>
									<span><?php echo esc_html( $arewa_mbn_post_type_item->label ); ?></span>
								</label>
							<?php endforeach; ?>
						</div>
						<p class="description"><?php esc_html_e( 'Click to select or deselect post types. Use the search box to filter post types.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
					</div>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label><?php esc_html_e( 'Device Visibility', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<select name="arewa_mbn_settings[device_visibility]" id="arewa_mbn_device_visibility">
						<option value="all" <?php selected( isset( $settings['device_visibility'] ) ? $settings['device_visibility'] : 'all', 'all' ); ?>><?php esc_html_e( 'All Devices', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="mobile_tablet" <?php selected( isset( $settings['device_visibility'] ) ? $settings['device_visibility'] : 'all', 'mobile_tablet' ); ?>><?php esc_html_e( 'Mobile & Tablet Only', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="mobile_only" <?php selected( isset( $settings['device_visibility'] ) ? $settings['device_visibility'] : 'all', 'mobile_only' ); ?>><?php esc_html_e( 'Mobile Only', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="tablet_only" <?php selected( isset( $settings['device_visibility'] ) ? $settings['device_visibility'] : 'all', 'tablet_only' ); ?>><?php esc_html_e( 'Tablet Only', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="desktop_only" <?php selected( isset( $settings['device_visibility'] ) ? $settings['device_visibility'] : 'all', 'desktop_only' ); ?>><?php esc_html_e( 'Desktop Only', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_hide_on_login"><?php esc_html_e( 'Hide on Login Page', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_hide_on_login_value = ( isset( $settings['hide_on_login'] ) && '1' === $settings['hide_on_login'] ) ? 'enable' : ( isset( $settings['hide_on_login'] ) ? 'disable' : 'enable' );
					?>
					<select name="arewa_mbn_settings[hide_on_login]" id="arewa_mbn_hide_on_login" class="arewa-mbn-enable-disable-select">
						<option value="disable" <?php selected( $arewa_mbn_hide_on_login_value, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="enable" <?php selected( $arewa_mbn_hide_on_login_value, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable to hide navigation on login/register pages, or disable to show it.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="arewa_mbn_hide_in_admin"><?php esc_html_e( 'Hide in Admin Dashboard', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_hide_in_admin_value = ( isset( $settings['hide_in_admin'] ) && '1' === $settings['hide_in_admin'] ) ? 'enable' : ( isset( $settings['hide_in_admin'] ) ? 'disable' : 'enable' );
					?>
					<select name="arewa_mbn_settings[hide_in_admin]" id="arewa_mbn_hide_in_admin" class="arewa-mbn-enable-disable-select">
						<option value="disable" <?php selected( $arewa_mbn_hide_in_admin_value, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="enable" <?php selected( $arewa_mbn_hide_in_admin_value, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable to hide navigation in WordPress admin area, or disable to show it.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
		</table>

		<h2><?php esc_html_e( 'WebView / App Conditions', 'arewa-mobile-bottom-navigation-bar' ); ?></h2>
		<p class="description"><?php esc_html_e( 'Configure visibility conditions for mobile apps and WebView environments using User-Agent detection.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>

		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="arewa_mbn_user_agent_enabled"><?php esc_html_e( 'Enable User-Agent Detection', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_user_agent_enabled_value = ( isset( $settings['user_agent_enabled'] ) && '1' === $settings['user_agent_enabled'] ) ? 'enable' : 'disable';
					?>
					<select name="arewa_mbn_settings[user_agent_enabled]" id="arewa_mbn_user_agent_enabled" class="arewa-mbn-enable-disable-select">
						<option value="disable" <?php selected( $arewa_mbn_user_agent_enabled_value, 'disable' ); ?>><?php esc_html_e( 'Disable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="enable" <?php selected( $arewa_mbn_user_agent_enabled_value, 'enable' ); ?>><?php esc_html_e( 'Enable', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'Enable to use User-Agent strings for app/WebView detection.', 'arewa-mobile-bottom-navigation-bar' ); ?></p>
				</td>
			</tr>
			<tr class="user-agent-settings-row" style="<?php echo ( 'enable' !== $arewa_mbn_user_agent_enabled_value ) ? 'display:none;' : ''; ?>">
				<th scope="row">
					<label for="arewa_mbn_user_agent_mode"><?php esc_html_e( 'Visibility Mode', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_user_agent_mode = isset( $settings['user_agent_mode'] ) ? $settings['user_agent_mode'] : 'show_all';
					?>
					<select name="arewa_mbn_settings[user_agent_mode]" id="arewa_mbn_user_agent_mode">
						<option value="show_all" <?php selected( $arewa_mbn_user_agent_mode, 'show_all' ); ?>><?php esc_html_e( 'Show Everywhere (No Restrictions)', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="show_only_in_app" <?php selected( $arewa_mbn_user_agent_mode, 'show_only_in_app' ); ?>><?php esc_html_e( 'Show Only in App/WebView', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
						<option value="hide_only_in_app" <?php selected( $arewa_mbn_user_agent_mode, 'hide_only_in_app' ); ?>><?php esc_html_e( 'Hide Only in App/WebView', 'arewa-mobile-bottom-navigation-bar' ); ?></option>
					</select>
					<p class="description">
						<?php esc_html_e( 'Choose how the navigation behaves based on User-Agent detection:', 'arewa-mobile-bottom-navigation-bar' ); ?><br>
						<strong><?php esc_html_e( 'Show Only in App/WebView:', 'arewa-mobile-bottom-navigation-bar' ); ?></strong> <?php esc_html_e( 'Navigation appears only when accessed from the configured User-Agents (apps/WebViews).', 'arewa-mobile-bottom-navigation-bar' ); ?><br>
						<strong><?php esc_html_e( 'Hide Only in App/WebView:', 'arewa-mobile-bottom-navigation-bar' ); ?></strong> <?php esc_html_e( 'Navigation is hidden when accessed from the configured User-Agents (apps/WebViews).', 'arewa-mobile-bottom-navigation-bar' ); ?>
					</p>
				</td>
			</tr>
			<tr class="user-agent-settings-row" style="<?php echo ( 'enable' !== $arewa_mbn_user_agent_enabled_value ) ? 'display:none;' : ''; ?>">
				<th scope="row">
					<label for="arewa_mbn_user_agent_list"><?php esc_html_e( 'User-Agent Strings', 'arewa-mobile-bottom-navigation-bar' ); ?></label>
				</th>
				<td>
					<?php
					$arewa_mbn_user_agent_list = isset( $settings['user_agent_list'] ) ? $settings['user_agent_list'] : array();
					$arewa_mbn_user_agent_text = is_array( $arewa_mbn_user_agent_list ) ? implode( "\n", $arewa_mbn_user_agent_list ) : '';
					?>
					<textarea name="arewa_mbn_settings[user_agent_list]" id="arewa_mbn_user_agent_list" rows="6" cols="50" class="large-text" placeholder="<?php esc_attr_e( 'Enter User-Agent strings, one per line...', 'arewa-mobile-bottom-navigation-bar' ); ?>"><?php echo esc_textarea( $arewa_mbn_user_agent_text ); ?></textarea>
					<p class="description">
						<?php esc_html_e( 'Enter User-Agent strings to detect apps/WebViews, one per line. Partial matches are supported (case-insensitive).', 'arewa-mobile-bottom-navigation-bar' ); ?><br>
						<?php esc_html_e( 'If your app WebView does not send the standard User-Agent header, set the same string in the X-User-Agent header.', 'arewa-mobile-bottom-navigation-bar' ); ?><br>
						<strong><?php esc_html_e( 'Examples:', 'arewa-mobile-bottom-navigation-bar' ); ?></strong><br>
						<code>MyApp/1.0</code> - <?php esc_html_e( 'Detects your custom app', 'arewa-mobile-bottom-navigation-bar' ); ?><br>
						<code>wv</code> - <?php esc_html_e( 'Detects Android WebView', 'arewa-mobile-bottom-navigation-bar' ); ?><br>
						<code>Mobile/</code> - <?php esc_html_e( 'Detects iOS WebView', 'arewa-mobile-bottom-navigation-bar' ); ?><br>
						<code>MyCompanyApp</code> - <?php esc_html_e( 'Detects any app containing this string', 'arewa-mobile-bottom-navigation-bar' ); ?><br><br>
						<strong><?php esc_html_e( 'Common WebView Patterns:', 'arewa-mobile-bottom-navigation-bar' ); ?></strong><br>
						<code>wv</code>, <code>Version/4.0</code>, <code>Mobile Safari</code> (Android WebView)<br>
						<code>Mobile/</code>, <code>Version/</code> (iOS WebView)<br>
						<code>Cordova</code>, <code>PhoneGap</code> (Hybrid apps)
					</p>
				</td>
			</tr>
		</table>

		<p class="submit">
			<input type="submit" name="arewa_mbn_save_visibility" class="button button-primary" value="<?php esc_attr_e( 'Save Settings', 'arewa-mobile-bottom-navigation-bar' ); ?>">
		</p>
	</form>
</div>
