<?php
/**
 * Frontend Navigation Template
 *
 * @package Arewa_Mobile_Bottom_Navigation
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get current URL for active state.
$arewa_mbn_http_host   = isset( $_SERVER['HTTP_HOST'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_HOST'] ) ) : '';
$arewa_mbn_request_uri = isset( $_SERVER['REQUEST_URI'] ) ? esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : '';
$arewa_mbn_current_url = ( is_ssl() ? 'https://' : 'http://' ) . $arewa_mbn_http_host . $arewa_mbn_request_uri;
$arewa_mbn_current_url = untrailingslashit( $arewa_mbn_current_url );

// Sort buttons by order.
usort(
	$buttons,
	function( $a, $b ) {
		return ( $a['order'] ?? 0 ) - ( $b['order'] ?? 0 );
	}
);

// Get layout style.
$arewa_mbn_layout_style            = isset( $settings['layout_style'] ) ? $settings['layout_style'] : 'icon_text';
$arewa_mbn_bg_color                = isset( $settings['background_color'] ) ? $settings['background_color'] : '#ffffff';
$arewa_mbn_border_radius           = isset( $settings['border_radius'] ) ? intval( $settings['border_radius'] ) : 0;
$arewa_mbn_box_shadow              = isset( $settings['box_shadow'] ) && '1' === $settings['box_shadow'];
$arewa_mbn_active_color            = isset( $settings['active_color'] ) ? $settings['active_color'] : '#0073aa';
$arewa_mbn_hover_effect            = isset( $settings['hover_effect'] ) && '1' === $settings['hover_effect'];
$arewa_mbn_pulse_animation         = isset( $settings['pulse_animation'] ) ? $settings['pulse_animation'] : '1';
$arewa_mbn_pulse_animation_enabled = ( '1' === $arewa_mbn_pulse_animation );
$arewa_mbn_button_text_size        = isset( $settings['button_text_size'] ) ? intval( $settings['button_text_size'] ) : 12;
$arewa_mbn_button_icon_size        = isset( $settings['button_icon_size'] ) ? intval( $settings['button_icon_size'] ) : 20;

// Convert active color to RGB for animation.
$arewa_mbn_active_color_rgb = array();
if ( 7 === strlen( $arewa_mbn_active_color ) && '#' === $arewa_mbn_active_color[0] ) {
	$arewa_mbn_active_color_rgb = array(
		hexdec( substr( $arewa_mbn_active_color, 1, 2 ) ),
		hexdec( substr( $arewa_mbn_active_color, 3, 2 ) ),
		hexdec( substr( $arewa_mbn_active_color, 5, 2 ) ),
	);
} else {
	$arewa_mbn_active_color_rgb = array( 0, 115, 170 ); // Default #0073aa.
}

// Submenu settings.
$arewa_mbn_submenu_bg_color                 = isset( $settings['submenu_bg_color'] ) ? $settings['submenu_bg_color'] : '#1e1e28';
$arewa_mbn_submenu_bg_opacity               = isset( $settings['submenu_bg_opacity'] ) ? intval( $settings['submenu_bg_opacity'] ) : 95;
$arewa_mbn_submenu_shadow                   = isset( $settings['submenu_shadow'] ) && '1' === $settings['submenu_shadow'];
$arewa_mbn_submenu_width                    = isset( $settings['submenu_width'] ) ? intval( $settings['submenu_width'] ) : 320;
$arewa_mbn_submenu_text_color               = isset( $settings['submenu_text_color'] ) ? $settings['submenu_text_color'] : '#ffffff';
$arewa_mbn_submenu_icon_spacing             = isset( $settings['submenu_icon_spacing'] ) ? intval( $settings['submenu_icon_spacing'] ) : 8;
$arewa_mbn_submenu_shadow_color             = isset( $settings['submenu_shadow_color'] ) ? $settings['submenu_shadow_color'] : '#000000';
$arewa_mbn_submenu_text_size                = isset( $settings['submenu_text_size'] ) ? intval( $settings['submenu_text_size'] ) : 14;
$arewa_mbn_submenu_icon_size                = isset( $settings['submenu_icon_size'] ) ? intval( $settings['submenu_icon_size'] ) : 22;
$arewa_mbn_submenu_header_enable            = isset( $settings['submenu_header_enable'] ) && '1' === $settings['submenu_header_enable'];
$arewa_mbn_submenu_header_logo              = isset( $settings['submenu_header_logo'] ) ? esc_url( $settings['submenu_header_logo'] ) : '';
$arewa_mbn_submenu_header_logo_size         = isset( $settings['submenu_header_logo_size'] ) ? intval( $settings['submenu_header_logo_size'] ) : 120;
$arewa_mbn_submenu_header_title             = isset( $settings['submenu_header_title'] ) ? esc_html( $settings['submenu_header_title'] ) : get_bloginfo( 'name' );
$arewa_mbn_submenu_header_description       = isset( $settings['submenu_header_description'] ) ? esc_html( $settings['submenu_header_description'] ) : '';
$arewa_mbn_submenu_header_bg_color          = isset( $settings['submenu_header_bg_color'] ) ? $settings['submenu_header_bg_color'] : 'transparent';
$arewa_mbn_submenu_header_title_color       = isset( $settings['submenu_header_title_color'] ) ? $settings['submenu_header_title_color'] : '#ffffff';
$arewa_mbn_submenu_header_title_size        = isset( $settings['submenu_header_title_size'] ) ? intval( $settings['submenu_header_title_size'] ) : 18;
$arewa_mbn_submenu_header_description_color = isset( $settings['submenu_header_description_color'] ) ? $settings['submenu_header_description_color'] : 'rgba(255, 255, 255, 0.7)';
$arewa_mbn_submenu_header_description_size  = isset( $settings['submenu_header_description_size'] ) ? intval( $settings['submenu_header_description_size'] ) : 13;

// Convert shadow color hex to rgba for shadow.
$arewa_mbn_submenu_shadow_rgb = array();
if ( 7 === strlen( $arewa_mbn_submenu_shadow_color ) && '#' === $arewa_mbn_submenu_shadow_color[0] ) {
	$arewa_mbn_submenu_shadow_rgb = array(
		hexdec( substr( $arewa_mbn_submenu_shadow_color, 1, 2 ) ),
		hexdec( substr( $arewa_mbn_submenu_shadow_color, 3, 2 ) ),
		hexdec( substr( $arewa_mbn_submenu_shadow_color, 5, 2 ) ),
	);
} else {
	$arewa_mbn_submenu_shadow_rgb = array( 0, 0, 0 );
}
$arewa_mbn_submenu_shadow_rgba = 'rgba(' . $arewa_mbn_submenu_shadow_rgb[0] . ', ' . $arewa_mbn_submenu_shadow_rgb[1] . ', ' . $arewa_mbn_submenu_shadow_rgb[2] . ', 0.4)';

// Convert hex color to rgba for opacity.
$arewa_mbn_submenu_bg_rgb = array();
if ( 7 === strlen( $arewa_mbn_submenu_bg_color ) && '#' === $arewa_mbn_submenu_bg_color[0] ) {
	$arewa_mbn_submenu_bg_rgb = array(
		hexdec( substr( $arewa_mbn_submenu_bg_color, 1, 2 ) ),
		hexdec( substr( $arewa_mbn_submenu_bg_color, 3, 2 ) ),
		hexdec( substr( $arewa_mbn_submenu_bg_color, 5, 2 ) ),
	);
} else {
	$arewa_mbn_submenu_bg_rgb = array( 30, 30, 40 );
}
$arewa_mbn_submenu_bg_rgba = 'rgba(' . $arewa_mbn_submenu_bg_rgb[0] . ', ' . $arewa_mbn_submenu_bg_rgb[1] . ', ' . $arewa_mbn_submenu_bg_rgb[2] . ', ' . ( $arewa_mbn_submenu_bg_opacity / 100 ) . ')';
?>

<div id="arewa-mbn-navigation"
	class="arewa-mbn-nav arewa-mbn-layout-<?php echo esc_attr( $arewa_mbn_layout_style ); ?> <?php echo $arewa_mbn_box_shadow ? 'arewa-mbn-shadow' : ''; ?> <?php echo $arewa_mbn_hover_effect ? 'arewa-mbn-hover' : ''; ?> <?php echo $arewa_mbn_pulse_animation_enabled ? 'arewa-mbn-pulse' : ''; ?>"
	style="background-color: <?php echo esc_attr( $arewa_mbn_bg_color ); ?>; --arewa-mbn-bg: <?php echo esc_attr( $arewa_mbn_bg_color ); ?>; --arewa-mbn-radius: <?php echo esc_attr( $arewa_mbn_border_radius ); ?>px; --arewa-mbn-active: <?php echo esc_attr( $arewa_mbn_active_color ); ?>; --arewa-mbn-active-rgb: <?php echo esc_attr( $arewa_mbn_active_color_rgb[0] . ', ' . $arewa_mbn_active_color_rgb[1] . ', ' . $arewa_mbn_active_color_rgb[2] ); ?>; --arewa-mbn-button-text-size: <?php echo esc_attr( $arewa_mbn_button_text_size ); ?>px; --arewa-mbn-button-icon-size: <?php echo esc_attr( $arewa_mbn_button_icon_size ); ?>px;">

	<?php
	// First pass: determine which button should be active (only one).
	$arewa_mbn_active_button_id  = null;
	$arewa_mbn_home_url_clean    = untrailingslashit( home_url() );
	$arewa_mbn_current_url_clean = untrailingslashit( $arewa_mbn_current_url );
	$arewa_mbn_best_match_length = 0;

	foreach ( $buttons as $arewa_mbn_button ) {
		$arewa_mbn_button_url = isset( $arewa_mbn_button['url'] ) ? $arewa_mbn_button['url'] : '#';
		if ( $arewa_mbn_button_url && '#' !== $arewa_mbn_button_url ) {
			$arewa_mbn_button_url_clean = untrailingslashit( esc_url( $arewa_mbn_button_url ) );

			// Check if it's the homepage button.
			if ( $arewa_mbn_home_url_clean === $arewa_mbn_button_url_clean || home_url() === $arewa_mbn_button_url_clean || '/' === $arewa_mbn_button_url_clean ) {
				// Only activate if we're actually on the homepage.
				if ( is_front_page() || $arewa_mbn_home_url_clean === $arewa_mbn_current_url_clean ) {
					if ( ! $arewa_mbn_active_button_id ) {
						$arewa_mbn_active_button_id = $arewa_mbn_button['id'];
					}
				}
			} elseif ( $arewa_mbn_button_url_clean === $arewa_mbn_current_url_clean ) { // Exact match for other pages.
				// Exact match takes priority.
				$arewa_mbn_active_button_id  = $arewa_mbn_button['id'];
				$arewa_mbn_best_match_length = strlen( $arewa_mbn_button_url_clean );
				break; // Exact match found, no need to continue.
			} elseif ( 0 === strpos( $arewa_mbn_current_url_clean, $arewa_mbn_button_url_clean ) && $arewa_mbn_home_url_clean !== $arewa_mbn_button_url_clean ) { // Check if current URL starts with button URL (for parent pages) - but be more strict.
				// Make sure it's not just matching the domain.
				$arewa_mbn_url_parts     = wp_parse_url( $arewa_mbn_button_url_clean );
				$arewa_mbn_current_parts = wp_parse_url( $arewa_mbn_current_url_clean );
				if ( isset( $arewa_mbn_url_parts['path'] ) && isset( $arewa_mbn_current_parts['path'] ) ) {
					$arewa_mbn_button_path  = rtrim( $arewa_mbn_url_parts['path'], '/' );
					$arewa_mbn_current_path = rtrim( $arewa_mbn_current_parts['path'], '/' );
					if ( $arewa_mbn_current_path === $arewa_mbn_button_path || 0 === strpos( $arewa_mbn_current_path, $arewa_mbn_button_path . '/' ) ) {
						// Use the longest matching path (most specific).
						if ( strlen( $arewa_mbn_button_path ) > $arewa_mbn_best_match_length ) {
							$arewa_mbn_active_button_id  = $arewa_mbn_button['id'];
							$arewa_mbn_best_match_length = strlen( $arewa_mbn_button_path );
						}
					}
				}
			}
		}
	}

	// Second pass: render buttons.
	foreach ( $buttons as $arewa_mbn_button ) :
		?>
		<?php
		$arewa_mbn_button_id        = $arewa_mbn_button['id'];
		$arewa_mbn_button_url       = isset( $arewa_mbn_button['url'] ) ? $arewa_mbn_button['url'] : '#';
		$arewa_mbn_button_label     = isset( $arewa_mbn_button['label'] ) ? $arewa_mbn_button['label'] : '';
		$arewa_mbn_icon             = isset( $arewa_mbn_button['icon'] ) ? Arewa_Mobile_Bottom_Navigation::normalize_svg_for_display( $arewa_mbn_button['icon'] ) : '';
		$arewa_mbn_icon_color       = isset( $arewa_mbn_button['icon_color'] ) ? $arewa_mbn_button['icon_color'] : '#333333';
		$arewa_mbn_text_color       = isset( $arewa_mbn_button['text_color'] ) ? $arewa_mbn_button['text_color'] : '#333333';
		$arewa_mbn_bg_color_btn     = isset( $arewa_mbn_button['bg_color'] ) ? $arewa_mbn_button['bg_color'] : 'transparent';
		$arewa_mbn_active_color_btn = isset( $arewa_mbn_button['active_color'] ) ? $arewa_mbn_button['active_color'] : $arewa_mbn_active_color;
		$arewa_mbn_target           = isset( $arewa_mbn_button['target'] ) ? $arewa_mbn_button['target'] : '_self';
		$arewa_mbn_has_submenu      = isset( $arewa_mbn_button['has_submenu'] ) && '1' === $arewa_mbn_button['has_submenu'];

		// Convert button's active color to RGB for animation.
		$arewa_mbn_active_color_btn_rgb = array();
		if ( 7 === strlen( $arewa_mbn_active_color_btn ) && '#' === $arewa_mbn_active_color_btn[0] ) {
			$arewa_mbn_active_color_btn_rgb = array(
				hexdec( substr( $arewa_mbn_active_color_btn, 1, 2 ) ),
				hexdec( substr( $arewa_mbn_active_color_btn, 3, 2 ) ),
				hexdec( substr( $arewa_mbn_active_color_btn, 5, 2 ) ),
			);
		} else {
			$arewa_mbn_active_color_btn_rgb = $arewa_mbn_active_color_rgb;
		}

		// Check if this button is active (only one can be active).
		$arewa_mbn_is_active = ( $arewa_mbn_active_button_id === $arewa_mbn_button_id );

		// Get submenu items if exists.
		$arewa_mbn_submenu_items = array();
		if ( $arewa_mbn_has_submenu && isset( $submenus[ $arewa_mbn_button_id ] ) ) {
			$arewa_mbn_submenu_items = $submenus[ $arewa_mbn_button_id ];
		}
		?>

		<div class="arewa-mbn-button-wrapper <?php echo esc_attr( trim( ( $arewa_mbn_has_submenu ? 'arewa-mbn-has-submenu' : '' ) . ' ' . ( $arewa_mbn_is_active ? 'arewa-mbn-active' : '' ) ) ); ?>">
			<?php if ( $arewa_mbn_has_submenu && ! empty( $arewa_mbn_submenu_items ) ) : ?>
				<button type="button" class="arewa-mbn-button arewa-mbn-submenu-trigger" 
	data-button-id="<?php echo esc_attr( $arewa_mbn_button_id ); ?>"
	style="background-color: <?php echo esc_attr( $arewa_mbn_bg_color_btn ); ?>; color: <?php echo esc_attr( $arewa_mbn_icon_color ); ?>; --arewa-mbn-icon-color: <?php echo esc_attr( $arewa_mbn_icon_color ); ?>; --arewa-mbn-text-color: <?php echo esc_attr( $arewa_mbn_text_color ); ?>; --arewa-mbn-bg-color: <?php echo esc_attr( $arewa_mbn_bg_color_btn ); ?>; --arewa-mbn-active-color: <?php echo esc_attr( $arewa_mbn_active_color_btn ); ?>; --arewa-mbn-active-rgb: <?php echo esc_attr( $arewa_mbn_active_color_btn_rgb[0] . ', ' . $arewa_mbn_active_color_btn_rgb[1] . ', ' . $arewa_mbn_active_color_btn_rgb[2] ); ?>;">
					<?php if ( $arewa_mbn_icon ) : ?>
						<span class="arewa-mbn-svg-wrapper"><?php echo wp_kses( Arewa_Mobile_Bottom_Navigation::sanitize_svg_output( $arewa_mbn_icon ), Arewa_Mobile_Bottom_Navigation::get_allowed_svg_kses() ); ?></span>
					<?php endif; ?>
					<?php if ( 'icon_text' === $arewa_mbn_layout_style || ( 'icon_text_active' === $arewa_mbn_layout_style && $arewa_mbn_is_active ) ) : ?>
						<span class="arewa-mbn-label"><?php echo esc_html( $arewa_mbn_button_label ); ?></span>
					<?php endif; ?>
				</button>

				<div class="arewa-mbn-submenu" 
	data-button-id="<?php echo esc_attr( $arewa_mbn_button_id ); ?>"
	style="background-color: <?php echo esc_attr( $arewa_mbn_submenu_bg_rgba ); ?> !important; min-width: <?php echo esc_attr( $arewa_mbn_submenu_width ); ?>px !important; --arewa-mbn-submenu-bg: <?php echo esc_attr( $arewa_mbn_submenu_bg_rgba ); ?>; --arewa-mbn-submenu-width: <?php echo esc_attr( $arewa_mbn_submenu_width ); ?>px; --arewa-mbn-submenu-text-color: <?php echo esc_attr( $arewa_mbn_submenu_text_color ); ?>; --arewa-mbn-submenu-icon-spacing: <?php echo esc_attr( $arewa_mbn_submenu_icon_spacing ); ?>px; --arewa-mbn-submenu-shadow-color: <?php echo esc_attr( $arewa_mbn_submenu_shadow_rgba ); ?>; --arewa-mbn-submenu-text-size: <?php echo esc_attr( $arewa_mbn_submenu_text_size ); ?>px; --arewa-mbn-submenu-icon-size: <?php echo esc_attr( $arewa_mbn_submenu_icon_size ); ?>px;">
					<?php if ( $arewa_mbn_submenu_header_enable ) : ?>
						<div class="arewa-mbn-submenu-header" style="background-color: <?php echo esc_attr( $arewa_mbn_submenu_header_bg_color ); ?> !important;">
							<?php if ( $arewa_mbn_submenu_header_logo ) : ?>
								<div class="arewa-mbn-submenu-header-logo" style="width: <?php echo esc_attr( $arewa_mbn_submenu_header_logo_size ); ?>px !important; height: <?php echo esc_attr( $arewa_mbn_submenu_header_logo_size ); ?>px !important; min-width: <?php echo esc_attr( $arewa_mbn_submenu_header_logo_size ); ?>px !important; min-height: <?php echo esc_attr( $arewa_mbn_submenu_header_logo_size ); ?>px !important; max-width: <?php echo esc_attr( $arewa_mbn_submenu_header_logo_size ); ?>px !important; max-height: <?php echo esc_attr( $arewa_mbn_submenu_header_logo_size ); ?>px !important;">
									<img src="<?php echo esc_url( $arewa_mbn_submenu_header_logo ); ?>" alt="<?php echo esc_attr( $arewa_mbn_submenu_header_title ); ?>">
								</div>
							<?php endif; ?>
							<div class="arewa-mbn-submenu-header-content">
								<div class="arewa-mbn-submenu-header-title" style="color: <?php echo esc_attr( $arewa_mbn_submenu_header_title_color ); ?> !important; font-size: <?php echo esc_attr( $arewa_mbn_submenu_header_title_size ); ?>px !important;">
									<?php echo esc_html( $arewa_mbn_submenu_header_title ); ?>
								</div>
								<?php if ( ! empty( $arewa_mbn_submenu_header_description ) ) : ?>
									<div class="arewa-mbn-submenu-header-description" style="color: <?php echo esc_attr( $arewa_mbn_submenu_header_description_color ); ?> !important; font-size: <?php echo esc_attr( $arewa_mbn_submenu_header_description_size ); ?>px !important;">
										<?php echo esc_html( $arewa_mbn_submenu_header_description ); ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
					<?php endif; ?>
					<?php foreach ( $arewa_mbn_submenu_items as $arewa_mbn_item ) : ?>
						<a href="<?php echo esc_url( $arewa_mbn_item['url'] ?? '#' ); ?>" 
	target="<?php echo esc_attr( $arewa_mbn_item['target'] ?? '_self' ); ?>"
	class="arewa-mbn-submenu-item"
	style="color: <?php echo esc_attr( $arewa_mbn_submenu_text_color ); ?> !important; --arewa-mbn-icon-color: <?php echo esc_attr( $arewa_mbn_item['icon_color'] ?? $arewa_mbn_submenu_text_color ); ?>; --arewa-mbn-submenu-text-color: <?php echo esc_attr( $arewa_mbn_submenu_text_color ); ?>; --arewa-mbn-submenu-icon-spacing: <?php echo esc_attr( $arewa_mbn_submenu_icon_spacing ); ?>px; --arewa-mbn-submenu-item-shadow: <?php echo esc_attr( $arewa_mbn_submenu_shadow ? '0 2px 8px ' . $arewa_mbn_submenu_shadow_rgba : 'none' ); ?>;">
							<?php if ( ! empty( $arewa_mbn_item['icon'] ) ) : ?>
								<?php
								$arewa_mbn_item_icon = Arewa_Mobile_Bottom_Navigation::normalize_svg_for_display( $arewa_mbn_item['icon'] );
								?>
								<span class="arewa-mbn-svg-wrapper" style="margin-right: <?php echo esc_attr( $arewa_mbn_submenu_icon_spacing ); ?>px !important;"><?php echo wp_kses( Arewa_Mobile_Bottom_Navigation::sanitize_svg_output( $arewa_mbn_item_icon ), Arewa_Mobile_Bottom_Navigation::get_allowed_svg_kses() ); ?></span>
							<?php endif; ?>
							<span><?php echo esc_html( $arewa_mbn_item['label'] ?? '' ); ?></span>
						</a>
					<?php endforeach; ?>
				</div>
			<?php else : ?>
				<a href="<?php echo esc_url( $arewa_mbn_button_url ); ?>" 
	target="<?php echo esc_attr( $arewa_mbn_target ); ?>"
	class="arewa-mbn-button <?php echo esc_attr( $arewa_mbn_is_active ? 'arewa-mbn-active' : '' ); ?>"
	style="background-color: <?php echo esc_attr( $arewa_mbn_bg_color_btn ); ?>; color: <?php echo esc_attr( $arewa_mbn_icon_color ); ?>; --arewa-mbn-icon-color: <?php echo esc_attr( $arewa_mbn_icon_color ); ?>; --arewa-mbn-text-color: <?php echo esc_attr( $arewa_mbn_text_color ); ?>; --arewa-mbn-bg-color: <?php echo esc_attr( $arewa_mbn_bg_color_btn ); ?>; --arewa-mbn-active-color: <?php echo esc_attr( $arewa_mbn_active_color_btn ); ?>; --arewa-mbn-active-rgb: <?php echo esc_attr( $arewa_mbn_active_color_btn_rgb[0] . ', ' . $arewa_mbn_active_color_btn_rgb[1] . ', ' . $arewa_mbn_active_color_btn_rgb[2] ); ?>;">
					<?php if ( $arewa_mbn_icon ) : ?>
						<span class="arewa-mbn-svg-wrapper"><?php echo wp_kses( Arewa_Mobile_Bottom_Navigation::sanitize_svg_output( $arewa_mbn_icon ), Arewa_Mobile_Bottom_Navigation::get_allowed_svg_kses() ); ?></span>
					<?php endif; ?>
					<?php if ( 'icon_text' === $arewa_mbn_layout_style || ( 'icon_text_active' === $arewa_mbn_layout_style && $arewa_mbn_is_active ) ) : ?>
						<span class="arewa-mbn-label"><?php echo esc_html( $arewa_mbn_button_label ); ?></span>
					<?php endif; ?>
				</a>
			<?php endif; ?>
		</div>
	<?php endforeach; ?>
</div>
